/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.design;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.loaders.DataObject;

public class WsitServiceChangeListener
implements ServiceChangeListener {
    Service service;
    Project project;
    DataObject dataObject;

    public WsitServiceChangeListener(Service service, DataObject dataObject, Project project) {
        this.service = service;
        this.project = project;
        this.dataObject = dataObject;
    }

    public void propertyChanged(String propertyName, String oldValue, String newValue) {
    }

    public void operationAdded(MethodModel method) {
        Binding binding = WSITModelSupport.getBinding(this.service, this.dataObject.getPrimaryFile(), this.project, false, null);
        if (binding != null) {
            BindingOperation bO = this.getBindingOperation(binding, method.getOperationName());
            if (bO == null) {
                bO = Util.generateOperation(binding, Util.getPortType(binding), method.getOperationName(), method.getImplementationClass());
            }
            if (SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding)) {
                String profile = ProfilesModelHelper.getSecurityProfile((WSDLComponent)binding);
                ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)bO)).setMessageLevelSecurityProfilePolicies((WSDLComponent)bO, profile);
            }
            WSITModelSupport.save((WSDLComponent)binding);
        }
    }

    private BindingOperation getBindingOperation(Binding binding, String operationName) {
        Collection bindingOperations = binding.getBindingOperations();
        for (BindingOperation bindingOperation : bindingOperations) {
            if (!bindingOperation.getName().equals(operationName)) continue;
            return bindingOperation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationRemoved(MethodModel method) {
        Binding binding = WSITModelSupport.getBinding(this.service, this.dataObject.getPrimaryFile(), this.project, false, null);
        if (binding != null) {
            WSDLModel model = binding.getModel();
            String methodName = method.getOperationName();
            Definitions d = model.getDefinitions();
            Collection messages = d.getMessages();
            Collection bOperations = binding.getBindingOperations();
            PortType portType = (PortType)d.getPortTypes().toArray()[0];
            Collection operations = portType.getOperations();
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                for (BindingOperation bOperation : bOperations) {
                    if (!methodName.equals(bOperation.getName())) continue;
                    ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)bOperation)).setMessageLevelSecurityProfilePolicies((WSDLComponent)bOperation, "       ");
                    binding.removeBindingOperation(bOperation);
                }
                for (Operation o : operations) {
                    if (!methodName.equals(o.getName())) continue;
                    portType.removeOperation(o);
                }
                for (Message m : messages) {
                    if (!methodName.equals(m.getName()) && !(methodName + "Response").equals(m.getName())) continue;
                    d.removeMessage(m);
                }
            }
            finally {
                if (!isTransaction) {
                    try {
                        model.endTransaction();
                    }
                    catch (IllegalStateException e) {
                        Logger.getLogger(WsitServiceChangeListener.class.getName()).log(Level.WARNING, null, e);
                    }
                }
            }
            WSITModelSupport.save((WSDLComponent)binding);
        }
    }

    public void operationChanged(MethodModel oldMethod, MethodModel newMethod) {
    }
}

