/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.UserDataConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificSecurity;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectSpecificSecurity
extends ProjectSpecificSecurity {
    private static final Logger logger = Logger.getLogger(WebProjectSpecificSecurity.class.getName());

    @Override
    public boolean unsetSSLAttributes(WSDLComponent c) {
        SecurityConstraint sc = WebProjectSpecificSecurity.getSecurityConstraint(c);
        if (sc != null) {
            try {
                FileObject webXmlFO = WebProjectSpecificSecurity.getDDFO(c);
                if (webXmlFO == null) {
                    return false;
                }
                WebApp webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
                if (webXmlDD != null && webXmlDD.getStatus() != 2) {
                    webXmlDD.removeSecurityConstraint(sc);
                    webXmlDD.write(webXmlFO);
                }
                return true;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return false;
    }

    @Override
    public boolean setSSLAttributes(WSDLComponent c) {
        if (WebProjectSpecificSecurity.getSecurityConstraint(c) == null) {
            FileObject webXmlFO = WebProjectSpecificSecurity.getDDFO(c);
            if (webXmlFO == null) {
                return false;
            }
            try {
                WebApp webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
                if (webXmlDD != null && webXmlDD.getStatus() != 2) {
                    SecurityConstraint sc = (SecurityConstraint)webXmlDD.createBean("SecurityConstraint");
                    AuthConstraint ac = (AuthConstraint)webXmlDD.createBean("AuthConstraint");
                    ac.addRoleName("EMPLOYEE");
                    sc.setAuthConstraint(ac);
                    UserDataConstraint udc = (UserDataConstraint)webXmlDD.createBean("UserDataConstraint");
                    udc.setTransportGuarantee("CONFIDENTIAL");
                    sc.setUserDataConstraint(udc);
                    String serviceName = null;
                    String urlPattern = "/";
                    boolean exit = false;
                    if (c instanceof Binding) {
                        Collection ss = c.getModel().getDefinitions().getServices();
                        for (Service s : ss) {
                            Collection pp = s.getPorts();
                            for (Port port : pp) {
                                QName qname = port.getBinding().getQName();
                                String bName = ((Binding)c).getName();
                                if (!bName.equals(qname.getLocalPart())) continue;
                                serviceName = s.getName();
                                urlPattern = urlPattern.concat(serviceName + "/*");
                                exit = true;
                                break;
                            }
                            if (!exit) continue;
                            break;
                        }
                    }
                    sc.setDisplayName(NbBundle.getMessage(WebProjectSpecificSecurity.class, (String)"LBL_SECCONSTRAINT_DNAME", serviceName));
                    WebResourceCollection wrc = (WebResourceCollection)webXmlDD.createBean("WebResourceCollection");
                    wrc.setHttpMethod(new String[]{"POST"});
                    wrc.setUrlPattern(new String[]{urlPattern});
                    wrc.setWebResourceName("Secure Area");
                    sc.addWebResourceCollection(wrc);
                    webXmlDD.addSecurityConstraint(sc);
                    webXmlDD.write(webXmlFO);
                    return true;
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private static SecurityConstraint getSecurityConstraint(WSDLComponent c) {
        FileObject webXmlFO = WebProjectSpecificSecurity.getDDFO(c);
        if (webXmlFO != null) {
            WebApp webXmlDD = null;
            try {
                webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, null, ioe);
            }
            String urlPattern = null;
            if (c instanceof Binding) {
                Collection ss = c.getModel().getDefinitions().getServices();
                for (Service s : ss) {
                    Collection pp = s.getPorts();
                    for (Port port : pp) {
                        QName qname = port.getBinding().getQName();
                        String bName = ((Binding)c).getName();
                        if (!bName.equals(qname.getLocalPart())) continue;
                        urlPattern = s.getName();
                    }
                }
            }
            if (webXmlDD != null && webXmlDD.getStatus() != 2) {
                SecurityConstraint[] constraints;
                for (SecurityConstraint sc : constraints = webXmlDD.getSecurityConstraint()) {
                    String wrcUrlPattern;
                    WebResourceCollection wrc = sc.getWebResourceCollection(0);
                    if (wrc == null || (wrcUrlPattern = wrc.getUrlPattern(0)) == null || !wrcUrlPattern.contains(urlPattern)) continue;
                    return sc;
                }
            }
        }
        return null;
    }

    private static FileObject getDDFO(WSDLComponent c) {
        WSDLModel model = c.getModel();
        FileObject fo = Util.getFOForModel(model);
        if (fo != null) {
            WebModule wm = WebModule.getWebModule((FileObject)fo);
            return wm.getDeploymentDescriptor();
        }
        return null;
    }
}

