/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class WSITMoveRefactoringPlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(WSITMoveRefactoringPlugin.class.getName());
    private MoveRefactoring refactoring;

    WSITMoveRefactoringPlugin(MoveRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void cancelRequest() {
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        FileObject classFo = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        if (classFo == null || classFo.isFolder()) {
            return null;
        }
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)classFo);
        if (support == null) {
            return null;
        }
        WSDLModel model = null;
        Project project = FileOwnerQuery.getOwner((FileObject)classFo);
        if (project == null) {
            return null;
        }
        try {
            model = WSITModelSupport.getModelForServiceFromJava(classFo, project, false, null);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (model == null) {
            return null;
        }
        String newPackageName = WSITMoveRefactoringPlugin.getPackageName((URL)this.refactoring.getTarget().lookup(URL.class));
        refactoringElements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new MoveClassElement(model, classFo, newPackageName));
        return null;
    }

    public static String getPackageName(URL url) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + url);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(suffix)) {
                    return WSITMoveRefactoringPlugin.getPackageName(fo);
                }
                String prefix = WSITMoveRefactoringPlugin.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + suffix;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    private static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    private static class MoveClassElement
    extends WSITRefactoringPlugin.AbstractRenameConfigElement {
        MoveClassElement(WSDLModel model, FileObject oldClass, String newPackageName) {
            super(model);
            String packageFqn = JavaIdentifiers.getQualifiedName((FileObject)oldClass.getParent());
            String oldConfName = this.getParentFile().getName();
            this.setOldConfigName(oldConfName);
            this.setNewConfigName(oldConfName.replace(packageFqn, newPackageName));
        }
    }
}

