/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class ServerUtils {
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    public static final String DEVNULL = "DEV-NULL";
    public static final String BUNDLED_TOMCAT_SETTING = "J2EE/BundledTomcat/Setting";

    public static J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID = ServerUtils.getServerInstanceID(project);
        if (serverInstanceID != null && serverInstanceID.length() > 0 && !DEVNULL.equals(serverInstanceID)) {
            try {
                return Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static String getServerInstanceID(Project p) {
        J2eeModuleProvider mp;
        if (p != null && (mp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            return mp.getServerInstanceID();
        }
        return null;
    }

    public static String getServerName(Project p) {
        String sID = ServerUtils.getServerInstanceID(p);
        if (sID != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(sID).getJ2eePlatform();
                return j2eePlatform.getDisplayName();
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static final boolean isTomcat(Project project) {
        String sID = ServerUtils.getServerInstanceID(project);
        return sID != null && sID != null && sID.toLowerCase().contains("tomcat");
    }

    public static final boolean isGlassfish(Project project) {
        if (project != null) {
            J2eeModuleProvider mp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (mp == null) {
                return false;
            }
            return ServerUtils.isGlassfish(mp.getServerInstanceID());
        }
        return false;
    }

    public static final boolean isGlassfish(String serverID) {
        return serverID != null && (serverID.toLowerCase().contains("appserv") || serverID.toLowerCase().contains("gfv3"));
    }

    public static J2eeModuleProvider getProvider(Project p) {
        if (p != null) {
            return (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        }
        return null;
    }

    public static FileObject getTomcatLocation(Project project) {
        InstalledFileLocator ifl;
        String catalinaHome = null;
        String catalinaBase = null;
        File homeDir = null;
        File baseDir = null;
        J2eeModuleProvider mp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties ip = null;
        if (mp != null) {
            ip = mp.getInstanceProperties();
        }
        String uri = ip.getProperty("url");
        String home = "home=";
        String base = ":base=";
        String uriString = "http://";
        int uriOffset = uri.indexOf("http://");
        int homeOffset = uri.indexOf("home=") + "home=".length();
        int baseOffset = uri.indexOf(":base=", homeOffset);
        if (homeOffset >= "home=".length()) {
            FileObject fo;
            int homeEnd = baseOffset > 0 ? baseOffset : (uriOffset > 0 ? uriOffset - 1 : uri.length());
            int baseEnd = uriOffset > 0 ? uriOffset - 1 : uri.length();
            catalinaHome = uri.substring(homeOffset, homeEnd);
            if (baseOffset > 0) {
                catalinaBase = uri.substring(baseOffset + ":base=".length(), baseEnd);
            }
            if (catalinaHome.length() > 0 && catalinaHome.charAt(0) == '$' && (fo = FileUtil.getConfigFile((String)BUNDLED_TOMCAT_SETTING)) != null) {
                catalinaHome = fo.getAttribute(catalinaHome.substring(1)).toString();
                if (catalinaBase != null && catalinaBase.length() > 0 && catalinaBase.charAt(0) == '$') {
                    catalinaBase = fo.getAttribute(catalinaBase.substring(1)).toString();
                }
            }
        }
        if (catalinaHome == null) {
            throw new IllegalArgumentException("CATALINA_HOME must not be null.");
        }
        homeDir = new File(catalinaHome);
        if (!homeDir.isAbsolute()) {
            InstalledFileLocator ifl2 = InstalledFileLocator.getDefault();
            homeDir = ifl2.locate(catalinaHome, null, false);
        }
        if (!homeDir.exists()) {
            throw new IllegalArgumentException("CATALINA_HOME directory does not exist.");
        }
        if (catalinaBase != null && !(baseDir = new File(catalinaBase)).isAbsolute() && (baseDir = (ifl = InstalledFileLocator.getDefault()).locate(catalinaBase, null, false)) == null) {
            baseDir = new File(System.getProperty("netbeans.user"), catalinaBase);
        }
        return baseDir == null ? (homeDir == null ? null : FileUtil.toFileObject((File)homeDir)) : FileUtil.toFileObject(baseDir);
    }

    public static FileObject getServerXml(Project p) {
        String confServerXml = "conf/server.xml";
        FileObject fO = ServerUtils.getTomcatLocation(p);
        return fO == null ? null : fO.getFileObject(confServerXml);
    }

    public static FileObject getTomcatLocation(String serverID) {
        if (serverID == null) {
            return null;
        }
        FileObject folder = null;
        try {
            String location;
            File f;
            int begin = serverID.indexOf("home=") + 5;
            int end = serverID.indexOf(":", serverID.indexOf("home=") + 1);
            if (end <= begin) {
                end = serverID.length();
            }
            if ((f = new File(location = serverID.substring(begin, end))) != null) {
                folder = FileUtil.toFileObject((File)f);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, serverID, ex);
        }
        return folder;
    }

    public static String getStoreLocation(Project project, boolean trust, boolean client) {
        String storeLocation = null;
        if (project == null) {
            return storeLocation;
        }
        J2eeModuleProvider mp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (mp != null) {
            String sID = mp.getServerInstanceID();
            InstanceProperties ip = mp.getInstanceProperties();
            if (ip == null || "".equals(ip.getProperty("LOCATION"))) {
                return "";
            }
            storeLocation = ServerUtils.getStoreLocation(sID, trust, client);
        }
        return storeLocation;
    }

    static String getStoreLocation(String serverInstanceID, boolean trust, boolean client) {
        String storeLocation = null;
        J2eePlatform j2eePlatform = null;
        File[] keyLocs = null;
        String store = null;
        try {
            j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
        }
        catch (InstanceRemovedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        store = client ? (trust ? "truststoreClient" : "keystoreClient") : (trust ? "truststore" : "keystore");
        keyLocs = j2eePlatform.getToolClasspathEntries(store);
        if (keyLocs != null && keyLocs.length > 0) {
            storeLocation = keyLocs[0].getAbsolutePath();
        }
        return storeLocation;
    }
}

