/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsitconf.projects.MavenWsitProvider;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class MavenWSITModelSupport {
    private static final Logger logger = Logger.getLogger(MavenWSITModelSupport.class.getName());

    public static WSDLModel getModel(Node node, Project project, JAXWSLightSupport jaxWsSupport, JaxWsService jaxService, UndoManagerHolder umHolder, boolean create, Collection<FileObject> createdFiles) throws MalformedURLException, Exception {
        boolean isClient;
        WSDLModel model = null;
        boolean bl = isClient = !jaxService.isServiceProvider();
        if (isClient) {
            model = MavenWSITModelSupport.getModelForClient(project, jaxWsSupport, jaxService, create, createdFiles);
        } else {
            FileObject implClass = (FileObject)node.getLookup().lookup(FileObject.class);
            try {
                String wsdlUrl = jaxService.getLocalWsdl();
                if (wsdlUrl == null) {
                    if (implClass == null || !implClass.isValid() || implClass.isVirtual()) {
                        logger.log(Level.INFO, "Implementation class is null or not valid, or just virtual: " + implClass + ", service: " + jaxService);
                        return null;
                    }
                    return WSITModelSupport.getModelForServiceFromJava(implClass, project, create, createdFiles);
                }
                if (project == null) {
                    return null;
                }
                return MavenWSITModelSupport.getModelForServiceFromWsdl(jaxWsSupport, jaxService);
            }
            catch (Exception e) {
                logger.log(Level.INFO, null, e);
            }
        }
        if (model != null && umHolder != null && umHolder.getUndoManager() == null) {
            UndoManager undoManager = new UndoManager();
            model.addUndoableEditListener((UndoableEditListener)undoManager);
            umHolder.setUndoManager(undoManager);
        }
        return model;
    }

    public static WSDLModel getModelForClient(Project p, JAXWSLightSupport jaxWsSupport, JaxWsService jaxWsService, boolean create, Collection<FileObject> createdFiles) throws IOException {
        URI uri = null;
        try {
            uri = jaxWsSupport.getWsdlFolder(false).getFileObject(jaxWsService.getLocalWsdl()).getURL().toURI();
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (uri == null) {
            return null;
        }
        return WSITModelSupport.getModelForClient(p, uri, create, createdFiles);
    }

    public static WSDLModel getServiceModelForClient(JAXWSLightSupport supp, JaxWsService client) throws IOException, Exception {
        FileObject originalWsdlFolder = supp.getWsdlFolder(false);
        FileObject originalWsdlFO = originalWsdlFolder.getFileObject(client.getLocalWsdl());
        if (originalWsdlFO != null && originalWsdlFO.isValid()) {
            return WSITModelSupport.getModelFromFO(originalWsdlFO, true);
        }
        return null;
    }

    private static WSDLModel getModelForServiceFromWsdl(JAXWSLightSupport supp, JaxWsService service) throws IOException, Exception {
        String wsdlLocation = service.getLocalWsdl();
        FileObject wsdlFO = supp.getWsdlFolder(false).getFileObject(wsdlLocation);
        return WSITModelSupport.getModelFromFO(wsdlFO, true);
    }

    public static boolean isMavenProject(Project p) {
        WsitProvider provider = (WsitProvider)p.getLookup().lookup(WsitProvider.class);
        return provider instanceof MavenWsitProvider;
    }
}

