/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTFileSystem;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTFileSystemProvider;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTUtil;
import org.openide.util.Pair;

public class NBJRTURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new NBJRTConnection(u);
    }

    private static final class NBJRTConnection
    extends URLConnection {
        private volatile Path path;

        NBJRTConnection(@NonNull URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            Pair<URL, String> parsed = NBJRTUtil.parseURL(this.url);
            if (parsed == null) {
                throw new IOException(String.format("Invalid URL: %s", this.url));
            }
            NBJRTFileSystem fs = NBJRTFileSystemProvider.getDefault().getFileSystem((URL)parsed.first());
            if (fs == null) {
                throw new IOException(String.format("Cannot create file system for: %s", this.url));
            }
            Path p = fs.getPath((String)parsed.second());
            if (p == null) {
                throw new IOException(String.format("Cannot resolve image path for: %s", this.url));
            }
            this.path = p;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            Path _path = this.path;
            if (_path == null) {
                throw new IOException(String.format("Cannot resolve: %s", this.getURL()));
            }
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
    }

    public static final class FactoryImpl
    implements URLStreamHandlerFactory {
        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if ("nbjrt".equals(protocol)) {
                return new NBJRTURLStreamHandler();
            }
            return null;
        }
    }
}

