/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

final class QueriesCache<T extends ResultBase> {
    private static final Logger LOG = Logger.getLogger(QueriesCache.class.getName());
    private static QueriesCache<Javadoc> javadoc;
    private static QueriesCache<Sources> sources;
    private static final char SEP = '-';
    private final Object lck = new Object();
    private final Class<T> clazz;
    private Map<URL, T> cache;

    private QueriesCache(@NonNull Class<T> clazz) {
        assert (clazz != null);
        this.clazz = clazz;
    }

    @NonNull
    Map<URL, ? extends T> getRoots() {
        return Collections.unmodifiableMap(this.loadRoots());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoot(URL binaryRoot, URL ... rootsToAttach) {
        ResultBase currentMapping = null;
        Object object = this.lck;
        synchronized (object) {
            Map<URL, T> currentRoots = this.loadRoots();
            currentMapping = (ResultBase)currentRoots.get(binaryRoot);
            Preferences root = NbPreferences.forModule(QueriesCache.class);
            Preferences node = root.node(this.clazz.getSimpleName());
            String binaryRootStr = binaryRoot.toExternalForm();
            try {
                for (String key : this.filterKeys(node.keys(), binaryRootStr)) {
                    node.remove(key);
                }
                for (int i = 0; i < rootsToAttach.length; ++i) {
                    node.put(String.format("%s-%d", binaryRootStr, i), rootsToAttach[i].toExternalForm());
                }
                node.flush();
            }
            catch (BackingStoreException bse) {
                Exceptions.printStackTrace((Throwable)bse);
            }
            if (currentMapping == null) {
                try {
                    currentMapping = (ResultBase)this.clazz.newInstance();
                    currentRoots.put(binaryRoot, currentMapping);
                }
                catch (InstantiationException ie) {
                    Exceptions.printStackTrace((Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    Exceptions.printStackTrace((Throwable)iae);
                }
            }
        }
        if (currentMapping != null) {
            currentMapping.update(Arrays.asList(rootsToAttach));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Map<URL, T> loadRoots() {
        Object object = this.lck;
        synchronized (object) {
            if (this.cache == null) {
                HashMap<URL, T> result = new HashMap<URL, T>();
                Preferences root = NbPreferences.forModule(QueriesCache.class);
                String folder = this.clazz.getSimpleName();
                try {
                    if (root.nodeExists(folder)) {
                        Preferences node = root.node(folder);
                        HashMap<URL, ArrayList<URL>> bindings = new HashMap<URL, ArrayList<URL>>();
                        for (String key : node.keys()) {
                            String value = node.get(key, null);
                            if (value == null) continue;
                            URL binUrl = this.getURL(key);
                            ArrayList<URL> binding = (ArrayList<URL>)bindings.get(binUrl);
                            if (binding == null) {
                                binding = new ArrayList<URL>();
                                bindings.put(binUrl, binding);
                            }
                            binding.add(new URL(value));
                        }
                        for (Map.Entry entry : bindings.entrySet()) {
                            ResultBase instance = (ResultBase)this.clazz.newInstance();
                            instance.update((Collection)entry.getValue());
                            result.put((URL)entry.getKey(), (T)instance);
                        }
                    }
                }
                catch (BackingStoreException bse) {
                    Exceptions.printStackTrace((Throwable)bse);
                }
                catch (MalformedURLException mue) {
                    Exceptions.printStackTrace((Throwable)mue);
                }
                catch (InstantiationException ie) {
                    Exceptions.printStackTrace((Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    Exceptions.printStackTrace((Throwable)iae);
                }
                this.cache = result;
            }
            return this.cache;
        }
    }

    private URL getURL(@NonNull String pattern) throws MalformedURLException {
        int index = pattern.lastIndexOf(45);
        assert (index > 0);
        return new URL(pattern.substring(0, index));
    }

    private Iterable<? extends String> filterKeys(String[] keys, String binaryRoot) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            String root;
            int index = keys[i].lastIndexOf(45);
            if (index <= 0 || !(root = keys[i].substring(0, index)).equals(binaryRoot)) continue;
            result.add(keys[i]);
        }
        return result;
    }

    @NonNull
    static synchronized QueriesCache<Javadoc> getJavadoc() {
        if (javadoc == null) {
            javadoc = new QueriesCache<Javadoc>(Javadoc.class);
        }
        return javadoc;
    }

    @NonNull
    static synchronized QueriesCache<Sources> getSources() {
        if (sources == null) {
            sources = new QueriesCache<Sources>(Sources.class);
        }
        return sources;
    }

    static class Sources
    extends ResultBase
    implements SourceForBinaryQueryImplementation2.Result {
        private volatile FileObject[] roots;

        Sources() {
        }

        public boolean preferSources() {
            return false;
        }

        public FileObject[] getRoots() {
            FileObject[] tmp = this.roots;
            return tmp == null ? new FileObject[]{} : Arrays.copyOf(tmp, tmp.length);
        }

        @Override
        protected void updateImpl(Collection<? extends URL> roots) {
            ArrayList<FileObject> fos = new ArrayList<FileObject>(roots.size());
            for (URL uRL : roots) {
                FileObject fo = URLMapper.findFileObject((URL)uRL);
                if (fo == null) continue;
                fos.add(fo);
            }
            this.roots = fos.toArray(new FileObject[fos.size()]);
        }

        @Override
        @NonNull
        protected List<? extends URI> getRootURIs() {
            ArrayList<URI> result = new ArrayList<URI>(this.roots.length);
            for (FileObject root : this.roots) {
                URI uri = root.toURI();
                if (uri != null) {
                    result.add(uri);
                    continue;
                }
                LOG.log(Level.WARNING, "Cannot convert: {0} to URI.", FileUtil.getFileDisplayName((FileObject)root));
            }
            return Collections.unmodifiableList(result);
        }
    }

    static class Javadoc
    extends ResultBase
    implements JavadocForBinaryQuery.Result {
        private volatile URL[] roots;

        Javadoc() {
        }

        public URL[] getRoots() {
            URL[] tmp = this.roots;
            return tmp == null ? new URL[]{} : Arrays.copyOf(tmp, tmp.length);
        }

        @Override
        protected void updateImpl(Collection<? extends URL> roots) {
            this.roots = roots.toArray(new URL[roots.size()]);
        }

        @Override
        @NonNull
        protected List<? extends URI> getRootURIs() {
            ArrayList<URI> result = new ArrayList<URI>(this.roots.length);
            for (URL root : this.roots) {
                try {
                    result.add(root.toURI());
                }
                catch (URISyntaxException ex) {
                    LOG.log(Level.WARNING, "Cannot convert: {0} to URI.", root);
                }
            }
            return Collections.unmodifiableList(result);
        }
    }

    static abstract class ResultBase {
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        ResultBase() {
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(@NonNull ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public final void update(Collection<? extends URL> roots) {
            this.updateImpl(roots);
            this.cs.fireChange();
        }

        protected abstract void updateImpl(Collection<? extends URL> var1);

        protected abstract List<? extends URI> getRootURIs();
    }
}

