/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.makeproject.api.wizards.MakeSampleProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.ui.MakeTemplateListener;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MakeProjectGeneratorImpl
extends ProjectGenerator {
    private static final String PROP_DBCONN = "dbconn";

    public MakeProject createBlankProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        MakeConfiguration[] confs = prjParams.getConfigurations();
        String projectFolderPath = prjParams.getProjectFolderPath();
        MakeConfiguration[] copyConfs = new MakeConfiguration[confs.length];
        for (int i = 0; i < confs.length; ++i) {
            copyConfs[i] = confs[i].clone();
            copyConfs[i].setBaseFSPath(new FSPath(prjParams.getSourceFileSystem(), projectFolderPath));
            RunProfile profile = (RunProfile)copyConfs[i].getAuxObject("runprofile");
            profile.setBuildFirst(false);
        }
        FileObject dirFO = this.createProjectDir(prjParams);
        prjParams.setConfigurations(copyConfs);
        this.createProject(dirFO, prjParams, true);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        if (prjParams.getOpenFlag()) {
            OpenProjects.getDefault().open(new Project[]{p}, false);
        }
        return p;
    }

    public MakeProject createProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        FileObject dirFO = this.createProjectDir(prjParams);
        this.createProject(dirFO, prjParams, false);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        if (prjParams.getDatabaseConnection() != null) {
            Preferences prefs = ProjectUtils.getPreferences((Project)p, ProjectSupport.class, (boolean)true);
            prefs.put(PROP_DBCONN, prjParams.getDatabaseConnection());
        }
        return p;
    }

    private MakeProjectHelper createProject(FileObject dirFO, ProjectGenerator.ProjectParameters prjParams, boolean saveNow) throws IOException {
        String name = prjParams.getProjectName();
        String makefileName = prjParams.getMakefileName();
        MakeConfiguration[] confs = prjParams.getConfigurations();
        if (prjParams.getCustomizerId() != null) {
            dirFO.createData("cndcustomizerid." + prjParams.getCustomizerId());
        }
        Iterator sourceFolders = prjParams.getSourceFolders();
        String sourceFoldersFilter = prjParams.getSourceFoldersFilter();
        Iterator testFolders = prjParams.getTestFolders();
        Iterator importantItems = prjParams.getImportantFiles();
        Iterator logicalFolderItems = prjParams.getLogicalFolderItems();
        Iterator logicalFolders = prjParams.getLogicalFolders();
        String mainFile = prjParams.getMainFile();
        MakeProjectHelper h = null;
        try {
            h = MakeProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.cnd.makeproject");
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        FileObject sourceBaseFO = dirFO;
        h.putPrimaryConfigurationData(data, true);
        MakeConfigurationDescriptor projectDescriptor = new MakeConfigurationDescriptor(dirFO, sourceBaseFO);
        if (makefileName != null) {
            projectDescriptor.setProjectMakefileName(makefileName);
        }
        projectDescriptor.init((Configuration[])confs);
        projectDescriptor.setState(ConfigurationDescriptor.State.READY);
        Project project = projectDescriptor.getProject();
        projectDescriptor.setProject(project);
        CreateMainParams mainFileParams = this.prepareMainIfNeeded(mainFile, dirFO, prjParams.getTemplateParams());
        if (sourceFoldersFilter != null && !"^(nbproject|build|test|tests)$".equals(sourceFoldersFilter)) {
            projectDescriptor.setFolderVisibilityQuery(sourceFoldersFilter);
        }
        projectDescriptor.initLogicalFolders(sourceFolders, sourceFolders == null, testFolders, logicalFolders, logicalFolderItems, importantItems, mainFileParams.mainFilePath, false);
        projectDescriptor.save();
        MakeTemplateListener instance = MakeTemplateListener.getInstance();
        if (instance != null) {
            instance.setContext(project, projectDescriptor);
        }
        mainFileParams.doPostProjectCreationWork();
        instance = MakeTemplateListener.getInstance();
        if (instance != null) {
            instance.clearContext();
        }
        projectDescriptor.closed();
        projectDescriptor.clean();
        if (!prjParams.isMakefileProject()) {
            FileObject baseDirFileObject = projectDescriptor.getBaseDirFileObject();
            FileObject createData = baseDirFileObject.createData(projectDescriptor.getProjectMakefileName());
            this.copyURLFile("nbresloc:/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile", createData.getOutputStream());
        }
        return h;
    }

    private void copyURLFile(String fromURL, OutputStream os) throws IOException {
        InputStream is = null;
        try {
            URL url = new URL(fromURL);
            is = url.openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            this.copy(is, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream is, OutputStream os) throws IOException {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            bw = new BufferedWriter(new OutputStreamWriter(os, FileEncodingQuery.getDefaultEncoding()));
            while ((line = br.readLine()) != null) {
                bw.write(line + "\n");
            }
            bw.flush();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
    }

    private FileObject createProjectDir(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        String projectFolderPath = prjParams.getProjectFolderPath();
        MakeSampleProjectGenerator.FOPath fopath = new MakeSampleProjectGenerator.FOPath(projectFolderPath);
        FileObject dirFO = fopath.root != null ? FileUtil.createFolder((FileObject)fopath.root, (String)fopath.relPath) : FileUtil.createFolder((FileObject)prjParams.getSourceFileSystem().getRoot(), (String)projectFolderPath);
        assert (dirFO != null) : "No such dir on disk: " + prjParams.getProjectFolderPath();
        assert (dirFO.isValid()) : "No such dir on disk: " + prjParams.getProjectFolderPath();
        assert (dirFO.isFolder()) : "Not really a dir: " + prjParams.getProjectFolderPath();
        return dirFO;
    }

    private CreateMainParams prepareMainIfNeeded(String mainFile, FileObject srcFolder, Map<String, Object> templateParams) throws IOException {
        String createdMainName;
        if (mainFile.length() == 0) {
            return new CreateMainParams(null, null, null);
        }
        String mainName = mainFile.substring(0, mainFile.indexOf(124));
        String template = mainFile.substring(mainFile.indexOf(124) + 1);
        if (mainName.length() == 0) {
            return new CreateMainParams(null, null, null);
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)template);
        if (mainTemplate == null) {
            return new CreateMainParams(null, null, null);
        }
        if (mainName.indexOf(92) > 0 || mainName.indexOf(47) > 0) {
            String absPath = CndPathUtilities.toAbsolutePath((FileObject)srcFolder, (String)mainName);
            absPath = FileSystemProvider.getCanonicalPath((FileSystem)srcFolder.getFileSystem(), (String)absPath);
            srcFolder = FileUtil.createFolder((FileObject)srcFolder, (String)CndPathUtilities.getDirName((String)mainName));
            createdMainName = CndPathUtilities.getBaseName((String)absPath);
        } else {
            createdMainName = mainName;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        DataFolder pDf = DataFolder.findFolder((FileObject)srcFolder);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("freeFileExtension", true);
        params.putAll(templateParams);
        Runnable runnable = () -> {
            try {
                mt.createFromTemplate(pDf, createdMainName, params);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        return new CreateMainParams(mainName, mt, runnable);
    }

    private static final class CreateMainParams {
        final String mainFilePath;
        final DataObject templateDO;
        private final Runnable postProjectSaveWorker;

        public CreateMainParams(String mainName, DataObject dob, Runnable postProjectSaveWorker) {
            this.mainFilePath = mainName;
            this.templateDO = dob;
            this.postProjectSaveWorker = postProjectSaveWorker;
        }

        private void doPostProjectCreationWork() {
            if (this.postProjectSaveWorker != null) {
                this.postProjectSaveWorker.run();
            }
        }
    }
}

