/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public final class TokenizerFactory {
    public static final Converter MACRO_CONVERTER = new Converter(){
        private final PathResolver resolver = new TrivialPathResolver();

        @Override
        public String convertToString(List<String> list) {
            return TokenizerFactory.convertToString(list, ' ');
        }

        @Override
        public List<String> convertToList(String text) {
            return TokenizerFactory.tokenize(text, new String[]{"-D"}, " ", this.resolver);
        }
    };
    public static final Converter UNDEF_CONVERTER = new Converter(){
        private final PathResolver resolver = new TrivialPathResolver();

        @Override
        public String convertToString(List<String> list) {
            return TokenizerFactory.convertToString(list, ' ');
        }

        @Override
        public List<String> convertToList(String text) {
            return TokenizerFactory.tokenize(text, new String[]{"-U"}, " ", this.resolver);
        }
    };
    public static final Converter DEFAULT_CONVERTER = new Converter(){

        @Override
        public String convertToString(List<String> list) {
            return TokenizerFactory.convertToString(list, ';');
        }

        @Override
        public List<String> convertToList(String text) {
            ArrayList<String> newList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(text, ";");
            while (st.hasMoreTokens()) {
                newList.add(st.nextToken());
            }
            return newList;
        }
    };

    public static Converter getPathConverter(final Project project, final Folder folder, final Item item, final String flag) {
        return new Converter(){
            private final PathResolver resolver = from -> {
                if (CndPathUtilities.isPathAbsolute((CharSequence)from)) {
                    return from;
                }
                if (project != null) {
                    return from;
                }
                if (folder != null) {
                    if (!folder.isDiskFolder()) return from;
                    String folderPath = folder.getRootPath();
                    folder.isDiskFolder();
                    if (folderPath == null) return from;
                    from = folderPath + "/" + from;
                    if (!CndPathUtilities.isPathAbsolute((CharSequence)from)) return from;
                    return CndPathUtilities.toAbsoluteOrRelativePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)from);
                }
                if (item == null) return from;
                from = CndPathUtilities.getDirName((String)item.getAbsolutePath()) + "/" + from;
                return CndPathUtilities.toAbsoluteOrRelativePath((String)item.getFolder().getConfigurationDescriptor().getBaseDir(), (String)from);
            };

            @Override
            public String convertToString(List<String> list) {
                return TokenizerFactory.convertToString(list, ';');
            }

            @Override
            public List<String> convertToList(String text) {
                return TokenizerFactory.tokenize(text, new String[]{flag}, "; ", this.resolver);
            }
        };
    }

    private static List<String> tokenize(String text, String[] keys, String SEPARATOR, PathResolver resolver) {
        List<String> splitLine = TokenizerFactory.splitLine(text, SEPARATOR);
        ArrayList<String> result = new ArrayList<String>();
        for (String s : splitLine) {
            if ((s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) && s.length() >= 2) {
                s = s.substring(1, s.length() - 1);
            }
            TokenizerFactory.addItem(result, keys, s, resolver);
        }
        return result;
    }

    private static List<String> splitLine(String line, String SEPARATOR) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        StringBuilder current = new StringBuilder();
        boolean isSingleQuoteMode = false;
        boolean isDoubleQuoteMode = false;
        int prev = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            if (SEPARATOR.indexOf(c) >= 0) {
                if (isSingleQuoteMode || isDoubleQuoteMode) {
                    current.append(c);
                } else if (current.length() > 0) {
                    res.add(current.toString());
                    current.setLength(0);
                }
            } else {
                switch (c) {
                    case '\'': {
                        if (prev != 92) {
                            if (isSingleQuoteMode) {
                                isSingleQuoteMode = false;
                            } else if (!isDoubleQuoteMode) {
                                isSingleQuoteMode = true;
                            }
                        }
                        current.append(c);
                        break;
                    }
                    case '\"': {
                        if (prev != 92) {
                            if (isDoubleQuoteMode) {
                                isDoubleQuoteMode = false;
                            } else if (!isSingleQuoteMode) {
                                isDoubleQuoteMode = true;
                            }
                        }
                        current.append(c);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (isSingleQuoteMode || isDoubleQuoteMode) {
                            current.append(c);
                            break;
                        }
                        if (current.length() <= 0) break;
                        res.add(current.toString());
                        current.setLength(0);
                        break;
                    }
                    default: {
                        current.append(c);
                    }
                }
            }
            prev = c;
        }
        if (current.length() > 0) {
            res.add(current.toString());
        }
        return res;
    }

    private static void addItem(List<String> result, String[] keys, String value, PathResolver resolver) {
        for (String key : keys) {
            if (!value.startsWith(key)) continue;
            String s = TokenizerFactory.removePrefix(key, value, resolver);
            if (!s.isEmpty()) {
                if (s.contains("\\\"")) {
                    s = s.replace("\\\"", "\"");
                }
                result.add(s);
            }
            return;
        }
        if (!value.startsWith("-") && !value.isEmpty()) {
            if (value.contains("\\\"")) {
                value = value.replace("\\\"", "\"");
            }
            result.add(value);
        }
    }

    private static String removePrefix(String prefix, String str, PathResolver resolver) {
        return str.startsWith(prefix) ? resolver.resolve(str.substring(prefix.length())) : str;
    }

    private static String convertToString(List<String> list, char separator) {
        boolean addSep = false;
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (addSep) {
                ret.append(separator);
            }
            ret.append(CndPathUtilities.quoteIfNecessary((String)list.get(i)));
            addSep = true;
        }
        return ret.toString();
    }

    private static final class TrivialPathResolver
    implements PathResolver {
        private TrivialPathResolver() {
        }

        @Override
        public String resolve(String from) {
            return from;
        }
    }

    private static interface PathResolver {
        public String resolve(String var1);
    }

    public static interface Converter {
        public String convertToString(List<String> var1);

        public List<String> convertToList(String var1);
    }
}

