/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = LogFactory.getLog(DefaultUserDestinationResolver.class);
    private final UserSessionRegistry userSessionRegistry;
    private String destinationPrefix = "/user/";

    public DefaultUserDestinationResolver(UserSessionRegistry userSessionRegistry) {
        Assert.notNull((Object)userSessionRegistry, (String)"'userSessionRegistry' must not be null");
        this.userSessionRegistry = userSessionRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix must not be empty");
        this.destinationPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public UserSessionRegistry getUserSessionRegistry() {
        return this.userSessionRegistry;
    }

    @Override
    public Set<String> resolveDestination(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        UserDestinationInfo info = this.getUserDestinationInfo(headers);
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String sessionId : info.getSessionIds()) {
            result.add(this.getTargetDestination(headers.getDestination(), info.getDestination(), sessionId, info.getUser()));
        }
        return result;
    }

    private UserDestinationInfo getUserDestinationInfo(SimpMessageHeaderAccessor headers) {
        Set<String> targetSessionIds;
        String targetDestination;
        String targetUser;
        String destination = headers.getDestination();
        Principal principal = headers.getUser();
        SimpMessageType messageType = headers.getMessageType();
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType) || SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            if (!this.checkDestination(destination, this.destinationPrefix)) {
                return null;
            }
            if (principal == null) {
                logger.error((Object)"Ignoring message, no principal info available");
                return null;
            }
            if (headers.getSessionId() == null) {
                logger.error((Object)"Ignoring message, no session id available");
                return null;
            }
            targetUser = principal.getName();
            targetDestination = destination.substring(this.destinationPrefix.length() - 1);
            targetSessionIds = Collections.singleton(headers.getSessionId());
        } else if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            if (!this.checkDestination(destination, this.destinationPrefix)) {
                return null;
            }
            int startIndex = this.destinationPrefix.length();
            int endIndex = destination.indexOf(47, startIndex);
            Assert.isTrue((endIndex > 0 ? 1 : 0) != 0, (String)"Expected destination pattern \"/principal/{userId}/**\"");
            targetUser = destination.substring(startIndex, endIndex);
            targetUser = StringUtils.replace((String)targetUser, (String)"%2F", (String)"/");
            targetDestination = destination.substring(endIndex);
            targetSessionIds = this.userSessionRegistry.getSessionIds(targetUser);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring " + (Object)((Object)messageType) + " message"));
            }
            return null;
        }
        return new UserDestinationInfo(targetUser, targetDestination, targetSessionIds);
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        if (destination == null) {
            logger.trace((Object)"Ignoring message, no destination");
            return false;
        }
        if (!destination.startsWith(requiredPrefix)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring message to " + destination + ", not a \"user\" destination"));
            }
            return false;
        }
        return true;
    }

    protected String getTargetDestination(String origDestination, String targetDestination, String sessionId, String user) {
        return targetDestination + "-user" + sessionId;
    }

    private static class UserDestinationInfo {
        private final String user;
        private final String destination;
        private final Set<String> sessionIds;

        private UserDestinationInfo(String user, String destination, Set<String> sessionIds) {
            this.user = user;
            this.destination = destination;
            this.sessionIds = sessionIds;
        }

        public String getUser() {
            return this.user;
        }

        public String getDestination() {
            return this.destination;
        }

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }
    }
}

