/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerJar
extends JPanel
implements HelpCtx.Provider {
    private J2SEProject project;
    private List<J2SECategoryExtensionProvider> compProviders = new LinkedList<J2SECategoryExtensionProvider>();
    private JCheckBox compressCheckBox;
    private JCheckBox copyLibs;
    private JTextField distDirField;
    private JLabel distDirLabel;
    private JCheckBox doJarCheckBox;
    private JTextField excludeField;
    private JLabel excludeLabel;
    private JLabel excludeMessage;
    private JPanel extPanel;
    private JPanel mainPanel;

    public CustomizerJar(J2SEProjectProperties uiProperties) {
        this.initComponents();
        int nextExtensionYPos = 0;
        this.project = uiProperties.getProject();
        for (J2SECategoryExtensionProvider compProvider : this.project.getLookup().lookupAll(J2SECategoryExtensionProvider.class)) {
            if (compProvider.getCategory() != J2SECategoryExtensionProvider.ExtensibleCategory.PACKAGING || !this.addExtPanel(this.project, compProvider, nextExtensionYPos)) continue;
            this.compProviders.add(compProvider);
            ++nextExtensionYPos;
        }
        this.addPanelFiller(nextExtensionYPos);
        this.distDirField.setDocument(uiProperties.DIST_JAR_MODEL);
        this.excludeField.setDocument(uiProperties.BUILD_CLASSES_EXCLUDES_MODEL);
        uiProperties.JAR_COMPRESS_MODEL.setMnemonic(this.compressCheckBox.getMnemonic());
        this.compressCheckBox.setModel(uiProperties.JAR_COMPRESS_MODEL);
        uiProperties.DO_JAR_MODEL.setMnemonic(this.doJarCheckBox.getMnemonic());
        this.doJarCheckBox.setModel(uiProperties.DO_JAR_MODEL);
        uiProperties.COPY_LIBS_MODEL.setMnemonic(this.copyLibs.getMnemonic());
        this.copyLibs.setModel(uiProperties.COPY_LIBS_MODEL);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerJar.class);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.distDirLabel = new JLabel();
        this.distDirField = new JTextField();
        this.excludeLabel = new JLabel();
        this.excludeField = new JTextField();
        this.excludeMessage = new JLabel();
        this.compressCheckBox = new JCheckBox();
        this.doJarCheckBox = new JCheckBox();
        this.copyLibs = new JCheckBox();
        this.extPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.distDirLabel.setLabelFor(this.distDirField);
        Mnemonics.setLocalizedText((JLabel)this.distDirLabel, (String)NbBundle.getMessage(CustomizerJar.class, (String)"LBL_CustomizeJar_DistDir_JTextField"));
        this.distDirField.setEditable(false);
        this.excludeLabel.setLabelFor(this.excludeField);
        Mnemonics.setLocalizedText((JLabel)this.excludeLabel, (String)NbBundle.getMessage(CustomizerJar.class, (String)"LBL_CustomizeJar_Excludes_JTextField"));
        this.excludeMessage.setLabelFor(this.excludeField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.excludeMessage, (String)bundle.getString("LBL_CustomizerJar_ExcludeMessage"));
        Mnemonics.setLocalizedText((AbstractButton)this.compressCheckBox, (String)NbBundle.getMessage(CustomizerJar.class, (String)"LBL_CustomizeJar_Commpres_JCheckBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.doJarCheckBox, (String)NbBundle.getMessage(CustomizerJar.class, (String)"CustomizerJar.doJarCheckBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.copyLibs, (String)NbBundle.getMessage(CustomizerJar.class, (String)"TXT_CopyLibraries"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 404, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compressCheckBox).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.doJarCheckBox).addGap(245, 245, 245)).addComponent(this.copyLibs).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludeLabel).addComponent(this.distDirLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludeMessage).addComponent(this.excludeField, -1, 289, Short.MAX_VALUE).addComponent(this.distDirField, -1, 289, Short.MAX_VALUE)))).addGap(0, 0, 0))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 161, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.distDirLabel).addComponent(this.distDirField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeLabel).addComponent(this.excludeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludeMessage).addGap(8, 8, 8).addComponent(this.compressCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doJarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyLibs).addContainerGap(-1, Short.MAX_VALUE))));
        this.distDirField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerJar.class).getString("AD_jTextFieldDistDir"));
        this.excludeField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerJar.class).getString("AD_jTextFieldExcludes"));
        this.compressCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerJar.class).getString("AD_jCheckBoxCompress"));
        this.doJarCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJar.class, (String)"ACSD_BuildJarAfterCompile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private boolean addExtPanel(Project p, J2SECategoryExtensionProvider compProvider, int gridY) {
        JComponent comp;
        if (compProvider != null && (comp = compProvider.createComponent(p, null)) != null) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = gridY;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
            return true;
        }
        return false;
    }

    private void addPanelFiller(int gridY) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = gridY;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.extPanel.add((Component)new Box.Filler(new Dimension(), new Dimension(), new Dimension(10000, 10000)), constraints);
    }
}

