/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.Native;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;

public class DenseMapInfoPointer<T extends void.ptr>
implements DenseMapInfo<T> {
    private final T emptykey;
    private final T tombstoneKey;

    public DenseMapInfoPointer(T emptykey, T tombstoneKey) {
        assert (tombstoneKey != null) : "tombstoneKey marker must be non null";
        assert (emptykey != null) : "emptyKey marker must be non null";
        assert (emptykey != tombstoneKey) : "emptyKey must be different from tombstoneKey";
        this.emptykey = emptykey;
        this.tombstoneKey = tombstoneKey;
    }

    @Override
    public T getEmptyKey() {
        return this.emptykey;
    }

    @Override
    public T getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public int getHashValue(Object PtrVal) {
        assert (PtrVal != this.emptykey) : "must not be called for emptyKey";
        assert (PtrVal != this.tombstoneKey) : "must not be called for tombstoneKey";
        if (PtrVal == null) {
            return 0;
        }
        return ((Native.NativeHashable)PtrVal).$hashcode();
    }

    @Override
    public boolean isEqual(Object LHS, Object RHS) {
        assert (LHS != this.emptykey) : "LHS: must not be called for emptyKey";
        assert (LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        return Native.$eq_ptr((void.ptr)((void.ptr)LHS), (void.ptr)((void.ptr)RHS));
    }

    @Override
    public boolean isKeyPointerLike() {
        return false;
    }
}

