/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapEntryBaseCharArray;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;

public class StringMapImpl {
    protected StringMapEntryBase[] TheTable;
    private int[] HashTable;
    protected int NumBuckets;
    protected int NumItems;
    protected int NumTombstones;
    protected int ItemSize;
    private static final StringMapEntryBase LAST_ENTRY = new StringMapEntryBaseDummy(2);
    private static final StringMapEntryBase TOMBSTONE_ENTRY = new StringMapEntryBaseDummy(0);
    protected static final int INVALID_INDEX = -1;

    protected StringMapImpl(int itemSize) {
        this.TheTable = null;
        this.NumBuckets = 0;
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.ItemSize = itemSize;
        this.HashTable = null;
    }

    protected StringMapImpl(int InitSize, int itemSize) {
        this.ItemSize = itemSize;
        if (InitSize != 0) {
            this.init(InitSize);
            return;
        }
        this.TheTable = null;
        this.NumBuckets = 0;
        this.NumItems = 0;
        this.NumTombstones = 0;
    }

    protected StringMapImpl(StringMapImpl RHS) {
        this.TheTable = RHS.TheTable;
        this.NumBuckets = RHS.NumBuckets;
        this.NumItems = RHS.NumItems;
        this.NumTombstones = RHS.NumTombstones;
        this.ItemSize = RHS.ItemSize;
        RHS.TheTable = null;
        RHS.NumBuckets = 0;
        RHS.NumItems = 0;
        RHS.NumTombstones = 0;
    }

    protected int RehashTable() {
        return this.RehashTable(0);
    }

    protected int RehashTable(int BucketNo) {
        int NewSize;
        if (this.NumItems * 4 > this.NumBuckets * 3) {
            NewSize = this.NumBuckets * 2;
        } else if (this.NumBuckets - (this.NumItems + this.NumTombstones) <= this.NumBuckets / 8) {
            NewSize = this.NumBuckets;
        } else {
            return BucketNo;
        }
        int NewBucketNo = BucketNo;
        StringMapEntryBase[] NewTableArray = new StringMapEntryBase[NewSize + 1];
        NewTableArray[NewSize] = LAST_ENTRY;
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket2 = this.TheTable[I];
            if (Bucket2 == null || Bucket2 == StringMapImpl.getTombstoneVal()) continue;
            int FullHash = Bucket2.FullHashCode;
            int NewBucket = FullHash & NewSize - 1;
            if (NewTableArray[NewBucket] == null) {
                NewTableArray[FullHash & NewSize - 1] = Bucket2;
                if (I != BucketNo) continue;
                NewBucketNo = NewBucket;
                continue;
            }
            int ProbeSize = 1;
            while (NewTableArray[NewBucket = NewBucket + ProbeSize++ & NewSize - 1] != null) {
            }
            NewTableArray[NewBucket] = Bucket2;
            if (I != BucketNo) continue;
            NewBucketNo = NewBucket;
        }
        std.free((Object)this.TheTable);
        this.TheTable = NewTableArray;
        this.NumBuckets = NewSize;
        this.NumTombstones = 0;
        return NewBucketNo;
    }

    protected final void resetForReuse() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket2 = this.TheTable[I];
            if (Bucket2 == null || Bucket2 == StringMapImpl.getTombstoneVal()) continue;
            Bucket2.resetStringMapEntryToInitialState();
        }
    }

    public static void resetStringMapEntryToInitialState(StringMapEntryBase entry) {
        assert (entry != null);
        entry.resetStringMapEntryToInitialState();
    }

    protected int LookupBucketFor(StringRef _Name) {
        char.ptr Name = _Name.data();
        int NameLen = _Name.size();
        int FullHashValue = llvm.HashString(new StringRef(_Name));
        return this.LookupBucketFor(Name, NameLen, FullHashValue);
    }

    protected int LookupBucketFor(char.ptr Name, int NameLen, int FullHashValue) {
        if (Native.$is_array_based((char.ptr)Name)) {
            return this.LookupBucketFor(Name.$array(), Name.$index(), NameLen, FullHashValue);
        }
        int HTSize = this.NumBuckets;
        if (HTSize == 0) {
            this.init(16);
            HTSize = this.NumBuckets;
        }
        int BucketNo = FullHashValue & HTSize - 1;
        int ProbeAmt = 1;
        int FirstTombstone = -1;
        while (true) {
            int ItemStrIndex;
            byte[] ItemStr;
            StringMapEntryBase BucketItem;
            if ((BucketItem = this.TheTable[BucketNo]) == null) {
                if (FirstTombstone != -1) {
                    return FirstTombstone;
                }
                return BucketNo;
            }
            if (BucketItem == StringMapImpl.getTombstoneVal()) {
                if (FirstTombstone == -1) {
                    FirstTombstone = BucketNo;
                }
            } else if (BucketItem.FullHashCode == FullHashValue && llvm.$eq_RawStringRef_with_null_termed(Name, NameLen, ItemStr = BucketItem.getKeyArray(), ItemStrIndex = BucketItem.getKeyArrayIndex())) {
                return BucketNo;
            }
            BucketNo = BucketNo + ProbeAmt & HTSize - 1;
            ++ProbeAmt;
        }
    }

    protected int LookupBucketFor(byte[] Name, int NameStartIndex, int NameLen, int FullHashValue) {
        int HTSize = this.NumBuckets;
        if (HTSize == 0) {
            this.init(16);
            HTSize = this.NumBuckets;
        }
        int BucketNo = FullHashValue & HTSize - 1;
        int ProbeAmt = 1;
        int FirstTombstone = -1;
        while (true) {
            int ItemStrIndex;
            byte[] ItemStr;
            StringMapEntryBase BucketItem;
            if ((BucketItem = this.TheTable[BucketNo]) == null) {
                if (FirstTombstone != -1) {
                    return FirstTombstone;
                }
                return BucketNo;
            }
            if (BucketItem == StringMapImpl.getTombstoneVal()) {
                if (FirstTombstone == -1) {
                    FirstTombstone = BucketNo;
                }
            } else if (BucketItem.FullHashCode == FullHashValue && llvm.$eq_RawStringRef_with_null_termed(Name, NameStartIndex, NameLen, ItemStr = BucketItem.getKeyArray(), ItemStrIndex = BucketItem.getKeyArrayIndex())) {
                return BucketNo;
            }
            BucketNo = BucketNo + ProbeAmt & HTSize - 1;
            ++ProbeAmt;
        }
    }

    protected int FindKey(StringRef Key) {
        return this.FindKey(Key.data(), Key.size());
    }

    protected int FindKey(char.ptr Key, int KeyLen) {
        int HTSize = this.NumBuckets;
        if (HTSize == 0) {
            return -1;
        }
        int FullHashValue = llvm.HashString(Key, KeyLen);
        int BucketNo = FullHashValue & HTSize - 1;
        int ProbeAmt = 1;
        StringMapEntryBase BucketItem;
        while ((BucketItem = this.TheTable[BucketNo]) != null) {
            int ItemStrIndex;
            byte[] ItemStr;
            if (BucketItem != StringMapImpl.getTombstoneVal() && BucketItem.FullHashCode == FullHashValue && llvm.$eq_RawStringRef_with_null_termed(Key, KeyLen, ItemStr = BucketItem.getKeyArray(), ItemStrIndex = BucketItem.getKeyArrayIndex())) {
                return BucketNo;
            }
            BucketNo = BucketNo + ProbeAmt & HTSize - 1;
            ++ProbeAmt;
        }
        return -1;
    }

    protected void RemoveKey(StringMapEntryBase V) {
        char.ptr VStr = V.getKeyStr();
        StringMapEntryBase V2 = this.RemoveKey(VStr, V.getKeyLength());
        assert (V == V2) : "Didn't find key?";
    }

    protected StringMapEntryBase RemoveKey(char.ptr Key, int KeyLen) {
        int Bucket2 = this.FindKey(Key, KeyLen);
        if (Bucket2 == -1) {
            return null;
        }
        StringMapEntryBase Result = this.TheTable[Bucket2];
        this.TheTable[Bucket2] = StringMapImpl.getTombstoneVal();
        --this.NumItems;
        ++this.NumTombstones;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        return Result;
    }

    private void init(int InitSize) {
        assert ((InitSize & InitSize - 1) == 0) : "Init Size must be a power of 2 or zero!";
        this.NumBuckets = InitSize != 0 ? InitSize : 16;
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.TheTable = new StringMapEntryBase[this.NumBuckets + 1];
        this.TheTable[this.NumBuckets] = LAST_ENTRY;
    }

    public static StringMapEntryBase getTombstoneVal() {
        return TOMBSTONE_ENTRY;
    }

    public int getNumBuckets() {
        return this.NumBuckets;
    }

    public int getNumItems() {
        return this.NumItems;
    }

    public boolean empty() {
        return this.NumItems == 0;
    }

    public int size() {
        return this.NumItems;
    }

    public void swap(StringMapImpl Other) {
        StringMapEntryBase[] TheTableOther = Other.TheTable;
        Other.TheTable = this.TheTable;
        this.TheTable = TheTableOther;
        int NumBucketsOther = Other.NumBuckets;
        Other.NumBuckets = this.NumBuckets;
        this.NumBuckets = NumBucketsOther;
        int NumItemsOther = Other.NumItems;
        Other.NumItems = this.NumItems;
        this.NumItems = NumItemsOther;
        int NumTombstonesOther = Other.NumTombstones;
        Other.NumTombstones = this.NumTombstones;
        this.NumTombstones = NumTombstonesOther;
    }

    private static final class StringMapEntryBaseDummy
    extends StringMapEntryBaseCharArray {
        public StringMapEntryBaseDummy(int Len) {
            super(Len);
        }
    }
}

