/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.uchar;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplUChar;
import org.llvm.support.llvm;

public class ArrayRefUChar
implements Iterable<Byte>,
Native.NativePOD<ArrayRefUChar> {
    private static final ArrayRefUChar NONE;
    private uchar.ptr Data;
    private int Length;
    private final boolean isDataPointerLike;

    public static ArrayRefUChar None() {
        return NONE;
    }

    public ArrayRefUChar() {
        this.Data = NativePointer.create_uchar$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
    }

    public ArrayRefUChar(NoneType $Prm0) {
        this.Data = NativePointer.create_uchar$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = false;
        if (NONE != null) {
            NativeTrace.printStackTraceOnce((Throwable)new Exception("use ArrayRefUChar.None() instead"));
        }
    }

    public ArrayRefUChar(byte OneElt) {
        this(OneElt, false);
    }

    public ArrayRefUChar(byte OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_uchar$ptr((byte[])NativePointer.new$uchar$elem((byte)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUChar(byte[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefUChar(byte[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_uchar$ptr((byte[])data), length, isDataPointerLike);
    }

    public ArrayRefUChar(uchar.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefUChar(uchar.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)data.clone();
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUChar(uchar.ptr begin, uchar.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefUChar(uchar.ptr begin, uchar.ptr end, boolean isDataPointerLike) {
        this.Data = (uchar.ptr)begin.clone();
        this.Length = end.$sub((abstract_iterator)begin);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefUChar(SmallVectorImplUChar Vec) {
        this.Data = (uchar.ptr)Vec.data().clone();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public <A> ArrayRefUChar(std.vectorUChar Vec) {
        this.Data = Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefUChar(std.vectorString Vec) {
        this.Data = (uchar.ptr)Vec.data();
        this.Length = Vec.size();
        this.isDataPointerLike = Vec.isDataPointerLike();
    }

    public ArrayRefUChar(byte[] Arr) {
        this(Arr, false);
    }

    public ArrayRefUChar(byte[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_uchar$ptr((byte[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefUChar(ArrayRefUChar other) {
        this.Data = Native.$tryClone((uchar.ptr)other.data());
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefUChar(JavaDifferentiators.JD.Move _dparam, ArrayRefUChar other) {
        this.Data = Native.$tryClone((uchar.ptr)other.data());
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public uchar.ptr begin() {
        return this.Data;
    }

    public uchar.ptr end() {
        return (uchar.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorUChar rbegin() {
        return new std.reverse_iteratorUChar((uchar.iterator)this.end());
    }

    public std.reverse_iteratorUChar rend() {
        return new std.reverse_iteratorUChar((uchar.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public uchar.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public byte front() {
        return this.Data.$at(0);
    }

    public byte back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefUChar copy(Class<Byte> cls, NativeMemory.Allocator A) {
        uchar.ptr Buff = (uchar.ptr)A.Allocate(cls, this.Length);
        std.copy((uchar.iterator)this.begin(), (uchar.iterator)this.end(), (uchar.iterator)Buff);
        return new ArrayRefUChar(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefUChar RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        uchar.ptr L = this.begin();
        uchar.ptr LE = this.end();
        uchar.ptr R = RHS.begin();
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((byte)L.$star(), (byte)R.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R.$preInc();
        }
        return true;
    }

    public ArrayRefUChar slice(int N) {
        return new ArrayRefUChar((uchar.ptr)this.data().$add(N), this.size() - N);
    }

    public ArrayRefUChar slice(int N, int M) {
        return new ArrayRefUChar((uchar.ptr)this.data().$add(N), M);
    }

    public ArrayRefUChar drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefUChar drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public byte $at(int Index) {
        return this.Data.$at(Index);
    }

    public byte $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public std.vectorUChar vec() {
        return new std.vectorUChar((uchar.iterator)this.Data, (uchar.iterator)this.Data.$add(this.Length), 0);
    }

    public std.vectorUChar $vector() {
        return new std.vectorUChar((uchar.iterator)this.Data, (uchar.iterator)this.Data.$add(this.Length), 0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((byte)this.$at(i), (byte)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefUChar $assign(ArrayRefUChar other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefUChar $assignMove(ArrayRefUChar other) {
        assert (this.isDataPointerLike == other.isDataPointerLike);
        uchar.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = DataTmp;
        other.Length = LengthTmp;
        return this;
    }

    public ArrayRefUChar clone() {
        if (this.getClass() != ArrayRefUChar.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefUChar(this);
    }

    public boolean $eq(ArrayRefUChar other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefUChar obj;
        NONE = obj = new ArrayRefUChar(NoneType.None);
    }

    private static final class ArrayRefIterator
    implements Iterator<Byte> {
        private final uchar.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(uchar.ptr Data, int Length) {
            this.localData = Native.$tryClone((uchar.ptr)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Byte next() {
            Byte val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public byte TPtr;

        public TRefOrNothing() {
            this.TPtr = 0;
        }

        public TRefOrNothing(byte TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

