/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapInfoUInt;

public class DenseMapIteratorUIntType<ValueT>
implements type.iterator<DenseMapIteratorUIntType<ValueT>, std_pair.pairUIntType<ValueT>>,
Cloneable {
    private final DenseMapInfoUInt keyInfoT;
    private std_pair.pairUIntType<ValueT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    protected DenseMapIteratorUIntType() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorUIntType(DenseMapInfoUInt keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorUIntType(DenseMapInfoUInt keyInfoT, std_pair.pairUIntType<ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIteratorUIntType(DenseMapInfoUInt keyInfoT, std_pair.pairUIntType<ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIteratorUIntType<ValueT> $assignMove(DenseMapIteratorUIntType<ValueT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIteratorUIntType(DenseMapIteratorUIntType<ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public std_pair.pairUIntType<ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pairUIntType<ValueT>> star$ref() {
        return new type.ref<std_pair.pairUIntType<ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIteratorUIntType.this.Ptr;
            }

            public std_pair.pairUIntType<ValueT> $deref() {
                return DenseMapIteratorUIntType.this.Buckets[this.localPtr];
            }

            public std_pair.pairUIntType<ValueT> $set(std_pair.pairUIntType<ValueT> value) {
                std_pair.pairUIntType pairUIntType2 = value;
                ((DenseMapIteratorUIntType)DenseMapIteratorUIntType.this).Buckets[this.localPtr] = pairUIntType2;
                return pairUIntType2;
            }

            public type.ptr<std_pair.pairUIntType<ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIteratorUIntType.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pairUIntType<ValueT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIteratorUIntType<ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIteratorUIntType<ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIteratorUIntType<ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIteratorUIntType<ValueT> $postInc() {
        DenseMapIteratorUIntType<ValueT> tmp = new DenseMapIteratorUIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        ++this.Ptr;
        return tmp;
    }

    private void AdvancePastEmptyBuckets() {
        int Empty = this.keyInfoT.getEmptyKey();
        int Tombstone = this.keyInfoT.getTombstoneKey();
        while (Native.$noteq((int)this.Ptr, (int)this.End) && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public DenseMapIteratorUIntType<ValueT> clone() {
        return new DenseMapIteratorUIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIteratorUIntType<ValueT> const_clone() {
        return new DenseMapIteratorUIntType<ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIteratorUIntType) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIteratorUIntType)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIteratorUIntType) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIteratorUIntType)other).Ptr);
        }
        return true;
    }
}

