/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.netbeans.modules.db.dataview.util.JXDateTimePicker;

public class DateTimePickerCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private boolean editable = true;
    private JXDateTimePicker datePicker;
    private DateFormat dateFormat;
    private ActionListener pickerActionListener;
    private boolean ignoreAction;
    private JTable table;

    public DateTimePickerCellEditor() {
        this(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public DateTimePickerCellEditor(DateFormat dateFormat) {
        this.dateFormat = dateFormat != null ? dateFormat : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.datePicker = new JXDateTimePicker();
        this.datePicker.getEditor().setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.datePicker.setFont(UIManager.getDefaults().getFont("TextField.font"));
        if (dateFormat != null) {
            this.datePicker.setFormats(dateFormat);
        }
        this.datePicker.addActionListener(this.getPickerActionListener());
    }

    @Override
    public Timestamp getCellEditorValue() {
        return this.datePicker.getDateTime();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return super.isCellEditable(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        this.ignoreAction = true;
        boolean canCommit = this.commitChange();
        this.ignoreAction = false;
        if (canCommit) {
            this.datePicker.setDateTime(null);
            return super.stopCellEditing();
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.ignoreAction = true;
        this.datePicker.setDateTime(this.getValueAsTimestamp(value));
        this.ignoreAction = false;
        return this.datePicker;
    }

    protected Timestamp getValueAsTimestamp(Object value) {
        if (this.isEmpty(value) || DataViewUtils.isSQLConstantString(value, null)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTime().getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof String) {
            try {
                return new Timestamp(this.dateFormat.parse((String)value).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Timestamp(System.currentTimeMillis());
    }

    protected boolean isEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).length() == 0;
    }

    protected boolean commitChange() {
        try {
            this.datePicker.commitEdit();
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public DateFormat[] getFormats() {
        return this.datePicker.getFormats();
    }

    public void setFormats(DateFormat ... formats) {
        this.datePicker.setFormats(formats);
    }

    private ActionListener getPickerActionListener() {
        if (this.pickerActionListener == null) {
            this.pickerActionListener = this.createPickerActionListener();
        }
        return this.pickerActionListener;
    }

    protected ActionListener createPickerActionListener() {
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateTimePickerCellEditor.this.ignoreAction) {
                    return;
                }
                this.terminateEdit(e);
            }

            private void terminateEdit(ActionEvent e) {
                if (e != null && "datePickerCommit".equals(e.getActionCommand())) {
                    DateTimePickerCellEditor.this.stopCellEditing();
                } else {
                    DateTimePickerCellEditor.this.cancelCellEditing();
                }
            }
        };
        return l;
    }

    public void addKeyListener(KeyListener kl) {
        this.datePicker.addKeyListener(kl);
    }
}

