/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.sql.Clob;
import java.sql.SQLException;
import org.netbeans.modules.db.dataview.util.RandomAccessOutputStream;
import org.openide.util.Exceptions;

public class FileBackedClob
implements Clob {
    private boolean freed = false;
    private File backingFile;

    public FileBackedClob() throws SQLException {
        try {
            this.backingFile = File.createTempFile("netbeans-db-blob", null);
            this.backingFile.deleteOnExit();
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    public FileBackedClob(String init) throws SQLException {
        this();
        this.setString(1L, init);
    }

    public FileBackedClob(Reader r) throws SQLException {
        this();
        Writer w = this.setCharacterStream(1L);
        int read = 0;
        char[] buffer = new char[(int)Math.pow(2.0, 18.0)];
        try {
            while ((read = r.read(buffer)) > 0) {
                w.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkFreed();
        return this.backingFile.length() / 4L;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkFreed();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.backingFile, "rw");
            raf.setLength(len * 4L);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void free() throws SQLException {
        if (!this.freed) {
            this.backingFile.delete();
            this.freed = true;
        }
    }

    private void checkFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("Blob already freed");
        }
    }

    private void checkPos(long pos) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Illegal Value for position: " + Long.toString(pos));
        }
    }

    private void checkLength(long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("Illegal Value for length: " + Long.toString(length));
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        this.checkLength(length);
        Reader r = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(this.backingFile), "UTF_32BE");
            r.skip(pos - 1L);
            CharBuffer c = CharBuffer.allocate(length);
            r.read(c);
            c.rewind();
            String string = c.toString();
            return string;
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        InputStreamReader r;
        this.checkFreed();
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(this.backingFile), "UTF_32BE");
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException(ex);
        }
        return r;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        Writer w = null;
        try {
            w = this.setCharacterStream(pos);
            w.write(str.substring(offset, Math.min(offset + len, str.length())));
            int n = len;
            return n;
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                w.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.backingFile, "rw");
            try {
                raf.seek((pos - 1L) * 4L);
            }
            catch (IOException ex) {
                raf.close();
                throw new SQLException(ex);
            }
            return new OutputStreamWriter((OutputStream)new RandomAccessOutputStream(raf), "UTF_32BE");
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkFreed();
        this.checkPos(pos);
        this.checkLength(length);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    File getBackingFile() {
        return this.backingFile;
    }
}

