/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class SourceTemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private static final Logger LOG = Logger.getLogger(SourceTemplateAttributesProvider.class.getName());

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String nameWithExtension) {
        FileObject templateFO = template.getPrimaryFile();
        if (!MIMENames.isFortranOrHeaderOrCppOrC((String)templateFO.getMIMEType()) || templateFO.isFolder()) {
            return null;
        }
        FileObject targetFO = target.getPrimaryFile();
        HashMap<String, String> map = new HashMap<String, String>();
        String packageName = target.getPrimaryFile().getPath().replace('/', '_');
        if (!packageName.isEmpty()) {
            packageName = packageName + "_";
        }
        String ext = "";
        String name = nameWithExtension;
        if (nameWithExtension.indexOf(46) > 0) {
            ext = nameWithExtension.substring(nameWithExtension.lastIndexOf(46) + 1);
            name = nameWithExtension.substring(0, nameWithExtension.lastIndexOf(46));
        }
        map.put("PACKAGE_AND_NAME", packageName + name);
        map.put("NAME", name);
        map.put("name", name);
        map.put("nameAndExt", nameWithExtension);
        map.put("EXTENSION", ext);
        String fullName = name + "_" + ext;
        StringBuilder guardName = new StringBuilder();
        for (int i = 0; i < fullName.length(); ++i) {
            char c = fullName.charAt(i);
            guardName.append(Character.isJavaIdentifierPart(c) ? (char)Character.toUpperCase(c) : (char)'_');
        }
        map.put("GUARD_NAME", guardName.toString());
        int crop = name.lastIndexOf(95);
        if (crop != -1) {
            name = name.substring(0, crop);
        }
        map.put("CROPPEDNAME", name);
        Date date = new Date();
        map.put("DATE", DateFormat.getDateInstance(1).format(date));
        map.put("TIME", DateFormat.getTimeInstance(3).format(date));
        map.put("USER", System.getProperty("user.name"));
        map.put("QUOTES", "\"");
        return map;
    }
}

