/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.sdoc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.lexer.api.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.sdoc.SDocComment;
import org.netbeans.modules.javascript2.sdoc.elements.SDocDescriptionElement;
import org.netbeans.modules.javascript2.sdoc.elements.SDocElement;
import org.netbeans.modules.javascript2.sdoc.elements.SDocElementType;
import org.netbeans.modules.javascript2.sdoc.elements.SDocElementUtils;
import org.netbeans.modules.parsing.api.Snapshot;

public class SDocParser {
    private static final Logger LOGGER = Logger.getLogger(SDocParser.class.getName());

    public static Map<Integer, SDocComment> parse(Snapshot snapshot) {
        HashMap<Integer, SDocComment> blocks = new HashMap<Integer, SDocComment>();
        TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence(JsTokenId.javascriptLanguage());
        if (tokenSequence == null) {
            return blocks;
        }
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != JsTokenId.DOC_COMMENT) continue;
            LOGGER.log(Level.FINEST, "SDocParser:comment block offset=[{0}-{1}],text={2}", new Object[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length(), tokenSequence.token().text()});
            OffsetRange offsetRange = new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length());
            blocks.put(offsetRange.getEnd(), SDocParser.parseCommentBlock(tokenSequence, offsetRange));
        }
        return blocks;
    }

    private static boolean isCommentImportantToken(Token<? extends JsDocumentationTokenId> token) {
        return token.id() != JsDocumentationTokenId.ASTERISK && token.id() != JsDocumentationTokenId.COMMENT_DOC_START;
    }

    private static TokenSequence getEmbeddedSDocTS(TokenSequence ts) {
        return ts.embedded(JsDocumentationTokenId.language());
    }

    private static SDocComment parseCommentBlock(TokenSequence ts, OffsetRange range) {
        TokenSequence ets = SDocParser.getEmbeddedSDocTS(ts);
        ArrayList<SDocElement> sDocElements = new ArrayList<SDocElement>();
        StringBuilder sb = new StringBuilder();
        boolean afterDescriptionEntry = false;
        SDocElementType lastType = null;
        int lastOffset = ts.offset();
        while (ets.moveNext()) {
            Token currentToken = ets.token();
            if (!SDocParser.isCommentImportantToken((Token<? extends JsDocumentationTokenId>)currentToken)) continue;
            if (currentToken.id() == JsDocumentationTokenId.KEYWORD || currentToken.id() == JsDocumentationTokenId.COMMENT_END) {
                if (sb.toString().trim().isEmpty()) {
                    if (lastType != null) {
                        sDocElements.add(SDocElementUtils.createElementForType(lastType, "", -1));
                    }
                } else {
                    if (!afterDescriptionEntry) {
                        sDocElements.add(SDocDescriptionElement.create(SDocElementType.DESCRIPTION, sb.toString().trim()));
                    } else {
                        sDocElements.add(SDocElementUtils.createElementForType(lastType, sb.toString().trim(), lastOffset));
                    }
                    sb = new StringBuilder();
                }
                while (ets.moveNext() && ets.token().id() == JsDocumentationTokenId.WHITESPACE) {
                }
                lastOffset = ets.offset();
                if (currentToken.id() != JsDocumentationTokenId.COMMENT_END) {
                    ets.movePrevious();
                }
                afterDescriptionEntry = true;
                CharSequence text = currentToken.text();
                lastType = SDocElementType.fromString(new StringBuilder(text.length()).append(text).toString());
                continue;
            }
            sb.append(currentToken.text());
        }
        return new SDocComment(range, sDocElements);
    }
}

