/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class BaseFilterNode
extends FilterNode {
    public static final String REFRESH_ANCESTOR_DISTANCE = "BaseFilterNode.refreshAncestorDistance";
    private static RequestProcessor RP = new RequestProcessor(BaseFilterNode.class);
    private static final Map<Node, Object> NODES_TO_REFRESH = new WeakHashMap<Node, Object>();

    public BaseFilterNode(Node original) {
        super(original);
    }

    public void destroy() throws IOException {
        int ancestorDistInt;
        super.destroy();
        Object ancestorDist = this.getOriginal().getValue(REFRESH_ANCESTOR_DISTANCE);
        int n = ancestorDistInt = ancestorDist instanceof Integer ? (Integer)ancestorDist : 0;
        if (ancestorDistInt > 0) {
            int currentDist;
            BaseFilterNode ancestor = this;
            for (currentDist = 0; currentDist < ancestorDistInt && ancestor.getParentNode() != null; ++currentDist) {
                ancestor = ancestor.getParentNode();
            }
            if (currentDist > 0) {
                BaseFilterNode.scheduleRefresh((Node)ancestor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleRefresh(final Node node) {
        Map<Node, Object> map = NODES_TO_REFRESH;
        synchronized (map) {
            if (NODES_TO_REFRESH.containsKey(node)) {
                return;
            }
            NODES_TO_REFRESH.put(node, new Object());
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{node});
                Map map = NODES_TO_REFRESH;
                synchronized (map) {
                    NODES_TO_REFRESH.remove(node);
                }
            }
        }, 250);
    }
}

