/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ant.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.gsf.testrunner.api.TestSession;

public final class AntLoggerUtils {
    public static final String TASK_JAVA = "java";
    public static final String TASK_JUNIT = "junit";
    public static final String TASK_TESTNG = "testng";

    public static TestSession.SessionType detectSessionType(AntEvent event, String caller) {
        String taskName = event.getTaskName();
        if (taskName == null) {
            return null;
        }
        if (taskName.equals(TASK_JUNIT) || taskName.equals(TASK_TESTNG)) {
            return TestSession.SessionType.TEST;
        }
        if (taskName.equals(TASK_JAVA)) {
            TaskStructure taskStructure = event.getTaskStructure();
            String className = taskStructure.getAttribute("classname");
            if (className == null) {
                return null;
            }
            className = event.evaluate(className);
            if (caller.equals(TASK_JUNIT) && (className.equals("junit.textui.TestRunner") || className.startsWith("org.junit.runner.") || className.equals("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner")) || caller.equals(TASK_TESTNG) && className.equals("org.testng.TestNG")) {
                TaskStructure[] nestedElems;
                for (TaskStructure ts : nestedElems = taskStructure.getChildren()) {
                    if (!ts.getName().equals("jvmarg")) continue;
                    String a = ts.getAttribute("value");
                    if (a != null) {
                        if (!event.evaluate(a).equals("-Xdebug")) continue;
                        return TestSession.SessionType.DEBUG;
                    }
                    a = ts.getAttribute("line");
                    if (a == null) continue;
                    for (String part : AntLoggerUtils.parseCmdLine(event.evaluate(a))) {
                        if (!part.equals("-Xdebug")) continue;
                        return TestSession.SessionType.DEBUG;
                    }
                }
                return TestSession.SessionType.TEST;
            }
            return null;
        }
        assert (false) : "Unhandled task name";
        return null;
    }

    public static List<String> parseCmdLine(String cmdLine) {
        if ((cmdLine = cmdLine.trim()).length() == 0) {
            return Collections.emptyList();
        }
        char[] chars = cmdLine.toCharArray();
        boolean simple = true;
        for (char c : chars) {
            if (c != ' ' && c != '\"' && c != '\'') continue;
            simple = false;
            break;
        }
        if (simple) {
            return Collections.singletonList(cmdLine);
        }
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuilder buf = new StringBuilder(20);
        boolean stateBeforeWord = false;
        boolean stateAfterWord = true;
        int stateInSingleQuote = 2;
        int stateInDoubleQuote = 3;
        int state = 0;
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 0: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    if (c == ' ') continue block7;
                    buf.append(c);
                    state = 1;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        state = 1;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case 2: {
                    if (c == '\'') {
                        state = 1;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case 1: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    if (c != ' ') continue block7;
                    result.add(buf.toString());
                    buf = new StringBuilder(20);
                    state = 0;
                    continue block7;
                }
                default: {
                    assert (false);
                    continue block7;
                }
            }
        }
        assert (state != 0);
        result.add(buf.toString());
        return result;
    }

    public static boolean isTestSessionType(TestSession.SessionType sessionType) {
        return sessionType != null;
    }
}

