/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.ui.wizard.ClientOptionsPanelGUI;
import org.netbeans.modules.mobility.end2end.ui.wizard.GenericServiceIterator;
import org.netbeans.modules.mobility.end2end.ui.wizard.WebApplicationPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClientOptionsPanel
implements WizardDescriptor.Panel,
ChangeListener {
    TemplateWizard templateWizard;
    private ClientOptionsPanelGUI gui;
    private final ArrayList<ChangeListener> listeners = new ArrayList();
    public static final HelpCtx HELP_CTX = new HelpCtx("me.wcb_clientoptions");
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String WPEM = "WizardPanel_errorMessage";

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new ClientOptionsPanelGUI();
            this.gui.setName(NbBundle.getMessage(WebApplicationPanel.class, (String)"TITLE_clientOptionsStep"));
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public void readSettings(Object settings) {
        this.templateWizard = (TemplateWizard)settings;
        Configuration configuration = (Configuration)this.templateWizard.getProperty("e2e-configuration");
        String clientName = null;
        ClientConfiguration cc = configuration.getClientConfiguration();
        if (cc == null) {
            ServerConfiguration sc = configuration.getServerConfigutation();
            ClassDescriptor cd = sc.getClassDescriptor();
            String servletName = cd.getLeafClassName();
            int pos = servletName.indexOf("Servlet");
            if (pos < 0) {
                pos = 0;
            }
            clientName = servletName.substring(0, pos) + "Client";
        } else {
            clientName = Templates.getTargetName((WizardDescriptor)this.templateWizard);
        }
        if (this.getComponent() != null) {
            this.gui.setValues(Templates.getProject((WizardDescriptor)this.templateWizard), clientName, Templates.getTargetFolder((WizardDescriptor)this.templateWizard));
        }
    }

    public void storeSettings(Object settings) {
        this.templateWizard = (TemplateWizard)settings;
        Configuration configuration = (Configuration)this.templateWizard.getProperty("e2e-configuration");
        ClientConfiguration cc = new ClientConfiguration();
        cc.setProjectName(this.gui.getProjectName());
        String className = this.gui.getPackageFileName();
        className = !"".equals(className) ? className + "." + this.gui.getTargetName() : this.gui.getTargetName();
        FileObject sourceRoot = this.gui.getRootFolder();
        className = className.replace('/', '.');
        ClassDescriptor cd = new ClassDescriptor(className, this.gui.getSourceGroup().getName());
        Templates.setTargetName((WizardDescriptor)this.templateWizard, (String)this.gui.getTargetName());
        this.templateWizard.putProperty(GenericServiceIterator.PROP_CLIENT_ROOT, (Object)sourceRoot);
        this.templateWizard.putProperty(GenericServiceIterator.PROP_DATABINDING, (Object)new Boolean(this.gui.isDataBinded()));
        cc.setClassDescriptor(cd);
        Properties props = new Properties();
        if (this.gui.isGenerateStubs()) {
            props.put("createStubs", TRUE);
        } else {
            props.put("createStubs", FALSE);
        }
        if (this.gui.isFloatingPointUsed()) {
            props.put("floatingPoint", TRUE);
        } else {
            props.put("floatingPoint", FALSE);
        }
        if (this.gui.isDataBinded()) {
            props.put("DataBinding", TRUE);
        } else {
            props.put("DataBinding", FALSE);
        }
        cc.setProperties(props);
        configuration.setClientConfiguration(cc);
    }

    public boolean isValid() {
        if (this.gui == null) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_NoGUI"));
            return false;
        }
        if (this.gui.getCreatedFile() != null && new File(this.gui.getCreatedFile()).exists()) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_AlreadyExists", (Object)(this.gui.getTargetName() + ".java")));
            return false;
        }
        if ("".equals(this.gui.getTargetName())) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_NoClassName"));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.gui.getTargetName())) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_InvalidClassName"));
            return false;
        }
        if (!ClientOptionsPanel.isValidJavaFolderName(this.gui.getPackageFileName())) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_InvalidPackageName"));
            return false;
        }
        this.templateWizard.putProperty(WPEM, (Object)" ");
        return true;
    }

    private static boolean isValidJavaFolderName(String packageFileName) {
        if (packageFileName == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(packageFileName, "/");
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            if (Utilities.isJavaIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.templateWizard != null) {
            this.templateWizard.setValid(this.isValid());
            this.fireChange();
        }
    }
}

