/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.javon;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;

public class OutputFileFormatter {
    private FileObject fileObject;
    private DataObject dataObject;
    private StyledDocument styledDocument;
    private IndentEngine indentEngine;
    private Writer writer;
    private StringWriter stringWriter;

    public OutputFileFormatter(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        this.fileObject = fileObject;
        this.dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
        this.styledDocument = editorCookie.openDocument();
        try {
            this.styledDocument.remove(0, this.styledDocument.getLength());
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.indentEngine = IndentEngine.find((Document)this.styledDocument);
        this.stringWriter = new StringWriter(4096);
        this.writer = this.indentEngine.createWriter((Document)this.styledDocument, 0, (Writer)this.stringWriter);
    }

    public void write(String data) {
        try {
            this.writer.write(data);
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
            String toInsert = this.stringWriter.getBuffer().delete(0, this.stringWriter.toString().lastIndexOf("//GEN-BEGIN:Client")).toString();
            this.styledDocument.insertString(0, toInsert.toString(), null);
            SaveCookie save = (SaveCookie)this.dataObject.getCookie(SaveCookie.class);
            if (save != null) {
                save.save();
            }
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

