/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.capture;

import org.netbeans.modules.cnd.debugger.common2.capture.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ProjectSupport;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

public final class CaptureInfo {
    public final String executable;
    public final int argc;
    public final String[] argv;
    public final String workingDirectory;
    public final int pid;
    public final ProjectSupport.Model model;
    public final String hostName;

    public CaptureInfo(String executable, int argc, String[] argv, String wd, int pid, ProjectSupport.Model model, String hostName) {
        this.executable = executable;
        this.argc = argc;
        this.argv = argv;
        this.workingDirectory = wd;
        this.pid = pid;
        this.model = model;
        this.hostName = hostName;
    }

    public String quotedArgvString() {
        String string = "";
        for (int cx = 1; cx < this.argc; ++cx) {
            string = string + IpeUtils.quoteIfNecessary(this.argv[cx]) + " ";
        }
        string = string.trim();
        return string;
    }

    public String argvString() {
        String string = "";
        for (int cx = 1; cx < this.argc; ++cx) {
            string = string + this.argv[cx] + " ";
        }
        String sub = string = string.trim();
        try {
            sub = string.substring(0, 50);
        }
        catch (StringIndexOutOfBoundsException x) {
            return sub;
        }
        sub = sub + " ...";
        return sub;
    }

    public String truncate(String str) {
        String sub = str;
        try {
            int len = str.length();
            sub = str.substring(len - 50, len);
        }
        catch (StringIndexOutOfBoundsException x) {
            return sub;
        }
        return "... " + sub;
    }

    public String messageString() {
        String msg = Catalog.format("FMT_CaughtMessage", this.truncate(this.executable), this.argvString(), this.truncate(this.workingDirectory));
        return msg;
    }
}

