/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

class LineBreakpointPanel
extends BreakpointPanel {
    private LineBreakpoint lb;
    private JTextField lineField;
    private JLabel lineLabel;
    private JButton browseButton;
    private JLabel fileLabel;
    private JTextField fileText;

    @Override
    public void seed(NativeBreakpoint breakpoint) {
        String s;
        this.seedCommonComponents(breakpoint);
        this.lb = (LineBreakpoint)breakpoint;
        if (this.lb.getLineNumber() >= 1) {
            this.lineField.setText(Integer.toString(this.lb.getLineNumber()));
        }
        if (!IpeUtils.isEmpty(s = this.lb.getFileName())) {
            this.fileText.setText(s.trim());
        }
    }

    public LineBreakpointPanel() {
        this(new LineBreakpoint(2), false);
    }

    public LineBreakpointPanel(NativeBreakpoint b) {
        this((LineBreakpoint)b, true);
    }

    private LineBreakpointPanel(LineBreakpoint breakpoint, boolean customizing) {
        super(breakpoint, customizing);
        FileObject mostRecentFileObject;
        this.lb = breakpoint;
        this.initComponents();
        this.addCommonComponents(2);
        if (!customizing && (mostRecentFileObject = EditorContextBridge.getMostRecentFileObject()) != null) {
            String fileName = mostRecentFileObject.getPath();
            int lineNo = EditorContextBridge.getMostRecentLineNumber();
            FileSystem fileSystem = null;
            try {
                fileSystem = mostRecentFileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            breakpoint.setFileAndLine(fileName, lineNo, fileSystem);
        }
        this.seed(breakpoint);
        this.fileText.getDocument().addDocumentListener(this);
        this.lineField.getDocument().addDocumentListener(this);
        this.lineField.selectAll();
        this.fileText.requestFocus();
    }

    @Override
    public void setDescriptionEnabled(boolean enabled) {
        this.lineField.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.fileText.setEnabled(false);
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileText = new JTextField();
        this.browseButton = new JButton();
        this.lineLabel = new JLabel();
        this.lineField = new JTextField();
        this.panel_settings.setLayout(new GridBagLayout());
        this.fileLabel.setText(Catalog.get("File"));
        this.fileLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_File"));
        this.fileLabel.setLabelFor(this.fileText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)this.fileLabel, gridBagConstraints);
        this.fileText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panel_settings.add((Component)this.fileText, gridBagConstraints);
        this.browseButton.setMnemonic(Catalog.getMnemonic("MNEM_Browse"));
        this.browseButton.setText(Catalog.get("Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineBreakpointPanel.this.onBrowse(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panel_settings.add((Component)this.browseButton, gridBagConstraints);
        this.lineLabel.setText(Catalog.get("Line"));
        this.lineLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Line"));
        this.lineLabel.setLabelFor(this.lineField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)this.lineLabel, gridBagConstraints);
        this.lineField.setColumns(12);
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new BorderLayout());
        linePanel.add((Component)this.lineField, "West");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)linePanel, gridBagConstraints);
        this.lineField.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_Line"));
        this.fileText.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_File"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(this.browseButton.getText());
    }

    private void onBrowse(ActionEvent evt) {
        NativeSession nativeSession;
        ExecutionEnvironment environment;
        FileSystem fileSystem;
        File seed = new File(this.fileText.getText());
        if (!seed.isDirectory()) {
            seed = seed.getParentFile();
        }
        if ((fileSystem = this.lb.getFileSystem()) != null) {
            environment = FileSystemProvider.getExecutionEnvironment((FileSystem)fileSystem);
        } else {
            environment = ServerList.getDefaultRecord().getExecutionEnvironment();
            this.lb.setFilesystem(FileSystemProvider.getFileSystem((ExecutionEnvironment)environment));
        }
        Session coreSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (coreSession != null && (nativeSession = NativeSession.map(coreSession)) != null) {
            environment = Host.byName(nativeSession.getSessionHost()).executionEnvironment();
            this.lb.setFilesystem(FileSystemProvider.getFileSystem((ExecutionEnvironment)environment));
        }
        FileChooserBuilder builder = new FileChooserBuilder(environment);
        FileChooserBuilder.JFileChooserEx chooser = builder.createFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        chooser.setCurrentDirectory(seed);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.fileText.setText(chooser.getSelectedFile().getParent() + "/" + chooser.getSelectedFile().getName());
        }
    }

    @Override
    protected void assignProperties() {
        int i = 1;
        try {
            i = Integer.parseInt(this.lineField.getText());
            if (i < 1) {
                i = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.lb.setFileAndLine(this.fileText.getText(), i);
    }

    @Override
    protected boolean propertiesAreValid() {
        if (IpeUtils.isEmpty(this.lineField.getText())) {
            return false;
        }
        try {
            int i = Integer.parseInt(this.lineField.getText());
            if (i < 1) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

