/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.beans.PropertyChangeSupport;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Exceptions;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetOwner;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.util.Utilities;

public abstract class DbgProfile
extends ProfileSupport
implements OptionSetOwner {
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_INTERCEPTLIST = "interceptlist";
    public static final String PROP_SIGNALS = "signals";
    public static final String PROP_PATHMAP = "pathmap";
    protected OptionSet options;
    protected boolean savedBuildFirst;
    protected boolean buildFirstOverriden;
    private final Configuration config;
    protected Signals signals;
    protected Exceptions exceptions;
    protected Pathmap pathmap;
    protected String redirection;
    protected String host;

    public DbgProfile() {
        this.config = null;
    }

    protected DbgProfile(PropertyChangeSupport pcs, Configuration configuration) {
        super(pcs);
        this.config = configuration;
    }

    public void initialize() {
    }

    @Override
    public OptionSet getOptions() {
        return this.options;
    }

    protected final void notifyOptionsChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_OPTIONS, null, null);
        }
        this.needSave = true;
    }

    public Pathmap pathmap() {
        return this.pathmap;
    }

    public Exceptions exceptions() {
        return this.exceptions;
    }

    public Signals signals() {
        return this.signals;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public void setRedirection(String infile, String outfile, boolean append) {
        boolean in;
        StringBuilder sb = new StringBuilder();
        boolean bl = in = infile != null && infile.length() != 0;
        if (in) {
            sb.append("< ");
            sb.append(infile);
        }
        if (outfile != null && outfile.length() != 0) {
            if (in) {
                sb.append(" ");
            }
            if (append) {
                sb.append(">> ");
            } else {
                sb.append("> ");
            }
            sb.append(outfile);
        }
        if (sb.length() != 0) {
            this.redirection = sb.toString();
            this.needSave = true;
        }
    }

    public String getDefaultHost() {
        return "localhost";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.needSave = true;
    }

    public boolean isDefaultHost() {
        return this.getHost().equals(this.getDefaultHost());
    }

    public void setBuildFirstOverriden(boolean buildFirstOverriden) {
        this.buildFirstOverriden = buildFirstOverriden;
        this.needSave = true;
    }

    public boolean isBuildFirstOverriden() {
        return this.buildFirstOverriden;
    }

    public boolean isSavedBuildFirst() {
        return this.savedBuildFirst;
    }

    public void setSavedBuildFirst(boolean savedBuildFirst) {
        this.savedBuildFirst = savedBuildFirst;
        this.needSave = true;
    }

    private String[] getDebugCommand() {
        String command = DebuggerOption.DEBUG_COMMAND.getCurrValue(this.options);
        if (this.config != null && this.config instanceof MakeConfiguration) {
            return Utilities.parseParameters((String)ProjectActionEvent.getRunCommandAsString((String)command, (MakeConfiguration)((MakeConfiguration)this.config), (PathMap)NativeDebuggerImpl.getPathMapFromConfig(this.config)));
        }
        return Utilities.parseParameters((String)"");
    }

    public String getExecutable() {
        String[] debugCommand = this.getDebugCommand();
        if (debugCommand.length == 0) {
            return "";
        }
        return debugCommand[0];
    }

    public String getArgsFlat() {
        String[] params = this.getDebugCommand();
        StringBuilder retVal = new StringBuilder();
        if (params.length > 1) {
            for (int i = 1; i < params.length; ++i) {
                retVal.append("\"").append(params[i]).append("\" ");
            }
        }
        return retVal.toString();
    }

    public String getDebugDir() {
        return DebuggerOption.DEBUG_DIR.getCurrValue(this.options);
    }

    public void setDebugDir(String value) {
        DebuggerOption.DEBUG_DIR.setCurrValue(this.options, value);
    }
}

