/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;

final class SignalTableModel
extends AbstractTableModel {
    private static final String ignored = Catalog.get("Signal_Ignored");
    private static final String ignoredDefault = Catalog.get("Signal_IgnoredDefault");
    private static final String caught = Catalog.get("Signal_Caught");
    private static final String caughtDefault = Catalog.get("Signal_CaughtDefault");
    private Signals signals;
    private static final int colCount = 4;
    private static final String[] columnName = new String[]{Catalog.get("Signal_Number"), Catalog.get("Signal_Signal"), Catalog.get("Signal_Desc"), Catalog.get("Signal_Handled")};

    private boolean haveSignals() {
        return this.signals != null;
    }

    @Override
    public int getRowCount() {
        if (this.haveSignals()) {
            return this.signals.count();
        }
        return 1;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnName[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.haveSignals() || rowIndex == 8) {
            return false;
        }
        return columnIndex == 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.haveSignals()) {
            if (columnIndex == 2) {
                return Catalog.get("NoSigsUntilDebug");
            }
            return "";
        }
        Signals.InitialSignalInfo signal = this.signals.getSignal(rowIndex);
        switch (columnIndex) {
            case 0: {
                return new Integer(signal.signo());
            }
            case 1: {
                return signal.name();
            }
            case 2: {
                return signal.description();
            }
            case 3: {
                if (signal.isCaught()) {
                    if (signal.isCaughtByDefault()) {
                        return caughtDefault;
                    }
                    return caught;
                }
                if (signal.isCaughtByDefault()) {
                    return ignored;
                }
                return ignoredDefault;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        Signals.InitialSignalInfo signal = this.signals.getSignal(rowIndex);
        if (signal == null) {
            return;
        }
        switch (columnIndex) {
            default: {
                assert (false) : "SetValueAt() for bad column " + columnIndex;
                break;
            }
            case 3: {
                String newString = newValue.toString();
                if (ignored.equals(newString)) {
                    signal.setCaught(false);
                } else if (caught.equals(newString)) {
                    signal.setCaught(true);
                } else {
                    assert (Catalog.get("Signal_Default").equals(newString));
                    signal.resetCaught();
                }
                this.signals.checkSignal();
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void signalsUpdated(Signals signals) {
        if (signals != null) assert (signals.isClone()) : "SignalTableModel.signalsUpdated() not getting a clone";
        if (this.haveSignals()) {
            this.fireTableRowsDeleted(0, this.signals.count());
        }
        this.signals = signals;
        if (signals == null) {
            return;
        }
        this.fireTableRowsInserted(0, signals.count());
    }

    public boolean isDefaultValue(int rowIndex) {
        if (!this.haveSignals()) {
            return true;
        }
        Signals.InitialSignalInfo s = this.signals.getSignal(rowIndex);
        if (s == null) {
            return true;
        }
        if (s.isCaught()) {
            return s.isCaughtByDefault();
        }
        return !s.isCaughtByDefault();
    }
}

