/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.masterdetail;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.DetailView;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Log;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Record;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordList;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListEvent;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListListener;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Validator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class MasterView<R extends Record>
extends JPanel
implements Validator {
    private final RecordList<R> recordList;
    private final DetailView<R> detailView;
    private JList list = null;
    private int targetSelection = 0;
    private boolean updating = false;
    private boolean dirty = false;
    public static final int MAX_VISIBLE_IN_MENU = 20;
    private JPanel listButtonPanel;
    private JButton deleteAllButton;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JTextArea guidanceText;
    private JScrollPane scrollPane;
    private Validator validator;

    public MasterView(RecordList<R> recordList, DetailView<R> detailView) {
        this.recordList = recordList;
        this.detailView = detailView;
        this.initComponents();
        this.list = new JList();
        this.list.setCellRenderer(new MyCellRenderer());
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        this.list.setListData(recordList.getRecordsDisplayName());
        this.scrollPane.setViewportView(this.list);
        this.list.setSelectedIndex(0);
        this.initAccessibility();
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (MasterView.this.updating) {
                    return;
                }
                if (!MasterView.this.canChangeSelection()) {
                    return;
                }
                MasterView.this.commitPending();
                MasterView.this.targetSelection = MasterView.this.list.getSelectedIndex();
                MasterView.this.updateView();
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.isConsumed()) {
                    return;
                }
                if (evt.getKeyChar() == '\u007f') {
                    evt.consume();
                    MasterView.this.deleteAction();
                }
            }
        });
        recordList.addRecordListListener(new RecordListListener(){

            @Override
            public void contentsChanged(RecordListEvent e) {
                MasterView.this.updateView();
            }
        });
        this.updateView();
    }

    boolean canChangeSelection() {
        if (this.detailView.isDirty()) {
            String msg = Catalog.get("MSG_APPLY_FIRST");
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)msg, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return false;
        }
        return true;
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleDescription(this.guidanceText.getText());
        context = this.list.getAccessibleContext();
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        context = this.scrollPane.getAccessibleContext();
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        context = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        context = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(this.duplicateButton.getText());
        this.deleteButton.getAccessibleContext().setAccessibleDescription(this.deleteButton.getText());
        this.deleteAllButton.getAccessibleContext().setAccessibleDescription(this.deleteAllButton.getText());
    }

    private void initComponents() {
        this.guidanceText = new JTextArea();
        this.scrollPane = new JScrollPane();
        this.listButtonPanel = new JPanel();
        this.duplicateButton = new JButton();
        this.deleteButton = new JButton();
        this.deleteAllButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.guidanceText.setBackground(new Color(204, 204, 204));
        this.guidanceText.setEditable(false);
        this.guidanceText.setLineWrap(true);
        this.guidanceText.setWrapStyleWord(true);
        this.guidanceText.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.guidanceText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.listButtonPanel.setLayout(new GridBagLayout());
        this.duplicateButton.setMnemonic(Catalog.get("LISTEDITDIALOG_DUPLICATE_BUTTON_MN").charAt(0));
        this.duplicateButton.setText(Catalog.get("LISTEDITDIALOG_DUPLICATE_BUTTON_TXT"));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterView.this.duplicateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.listButtonPanel.add((Component)this.duplicateButton, gridBagConstraints);
        this.deleteButton.setMnemonic(Catalog.get("LISTEDITDIALOG_DELETE_BUTTON_MN").charAt(0));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setText(Catalog.get("LISTEDITDIALOG_DELETE_BUTTON_TXT"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterView.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.listButtonPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteAllButton.setMnemonic(Catalog.get("LISTEDITDIALOG_DELETE_ALL_BUTTON_MN").charAt(0));
        this.deleteAllButton.setText(Catalog.get("LISTEDITDIALOG_DELETE_ALL_BUTTON_TXT"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterView.this.deleteAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.listButtonPanel.add((Component)this.deleteAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 7, 0, 11);
        this.add((Component)this.listButtonPanel, gridBagConstraints);
    }

    private void duplicateAction() {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (this.detailView != null && this.detailView.isDirty()) {
            String msg = Catalog.get("MSG_CANNOT_DUPLICATE");
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)msg, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return;
        }
        R record = this.recordList.getRecordAt(selectedIndex);
        Record dup = record.cloneRecord();
        String newKey = this.recordList.newKey();
        if (newKey != null) {
            dup.setKey(newKey);
        }
        this.targetSelection = selectedIndex + 1;
        this.recordList.addRecordAfter(dup, selectedIndex);
        this.setDirty(true);
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        this.duplicateAction();
    }

    private void deleteAllAction() {
        this.recordList.removeAllButArchetype();
        this.setDirty(true);
    }

    private void deleteAllButtonActionPerformed(ActionEvent evt) {
        this.deleteAllAction();
    }

    private void deleteAction() {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.recordList.removeRecordAt(selectedIndex);
        this.setDirty(true);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteAction();
    }

    protected void closeAction() {
    }

    private void updateButtons() {
        int selection = this.list.getSelectedIndex();
        if (Log.MasterDetail.debug) {
            System.out.printf("ModelView.updateButtons(): selection = %d\n", selection);
        }
        if (this.recordList.getSize() > 0) {
            if (selection >= 0) {
                R record = this.recordList.getRecordAt(selection);
                this.duplicateButton.setEnabled(true);
                this.deleteButton.setEnabled(!record.isArchetype());
                boolean soleArchetype = this.recordList.getSize() == 1 && record.isArchetype();
                this.deleteAllButton.setEnabled(!soleArchetype);
            } else {
                this.duplicateButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.deleteAllButton.setEnabled(true);
            }
        } else {
            this.duplicateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.deleteAllButton.setEnabled(false);
        }
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    void commitPending() {
        if (this.detailView.isRecordValid() && this.detailView.isDirty()) {
            this.detailView.commit();
            this.setDirty(true);
        }
    }

    public final void updateView() {
        if (Log.MasterDetail.debug) {
            System.out.printf("MasterView.updateView(): targetSelection=%d\n", this.targetSelection);
        }
        if (this.recordList.getSize() <= 0) {
            this.targetSelection = -1;
        } else if (this.targetSelection < 0) {
            this.targetSelection = 0;
        } else if (this.targetSelection >= this.recordList.getSize()) {
            this.targetSelection = this.recordList.getSize() - 1;
        }
        try {
            this.updating = true;
            this.list.setListData(this.recordList.getRecordsDisplayName());
            this.list.setSelectedIndex(this.targetSelection);
            this.list.ensureIndexIsVisible(this.targetSelection);
        }
        finally {
            this.updating = false;
        }
        this.updateButtons();
        this.detailView.setRecord(this.recordList.getRecordAt(this.targetSelection));
    }

    protected HelpCtx getHelpCtx() {
        return null;
    }

    public boolean updateModifiedDialog(int selectedIndex) {
        JButton updateButton = new JButton(Catalog.get("MODIFIEDDIALOG_UPDATE_BUTTON_TXT"));
        JButton cancelButton = new JButton(Catalog.get("MODIFIEDDIALOG_CANCEL_BUTTON_TXT"));
        updateButton.getAccessibleContext().setAccessibleDescription(Catalog.get("MODIFIEDDIALOG_UPDATE_BUTTON_ACSD"));
        cancelButton.getAccessibleContext().setAccessibleDescription(Catalog.get("MODIFIEDDIALOG_CANCEL_BUTTON_ACSD"));
        NotifyDescriptor d = new NotifyDescriptor((Object)Catalog.get("MODIFIEDDIALOG_COMMANDS_MODIFIED"), Catalog.get("MODIFIEDDIALOG_UNSAVED_MODIFICATIONS"), 2, 2, (Object[])new JButton[]{updateButton, cancelButton}, (Object)updateButton);
        return DialogDisplayer.getDefault().notify(d) == updateButton;
    }

    public JList getList() {
        return this.list;
    }

    void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.fireChanged();
    }

    @Override
    public void fireChanged() {
        if (this.validator != null) {
            this.validator.fireChanged();
        }
    }

    @Override
    public boolean isRecordValid() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (index == 20) {
                this.setBorder(new MatteBorder(new Insets(2, 0, 0, 0), Color.gray));
            } else {
                this.setBorder(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

