/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.options.CatalogDynamic;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Option;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.netbeans.modules.cnd.debugger.common2.utils.options.SubcategoryOptionUI;

public abstract class OptionUI {
    protected Option optionType = null;
    protected OptionValue value = null;
    protected JLabel label = null;
    protected boolean hasLabel = true;
    protected static final int LABEL_COLUMNS_MAX = 25;
    protected static final int LABEL_COLUMNS_MIN = 10;
    String currValue = null;

    OptionUI(Option inOption) {
        this(inOption, true, 25);
    }

    OptionUI(Option inOption, boolean hasLabel) {
        this(inOption, hasLabel, 25);
    }

    OptionUI(Option inOption, int labelColumns) {
        this(inOption, true, labelColumns);
    }

    OptionUI(Option inOption, boolean hasLabel, int labelColumns) {
        this.optionType = inOption;
        if (hasLabel) {
            hasLabel = inOption.overrideHasLabel();
        }
        this.hasLabel = hasLabel;
    }

    void bind(OptionSet options) {
        this.value = options.byType(this.optionType);
        if (this.value != null) {
            this.currValue = this.value.get();
            this.updateUI();
        }
    }

    public JLabel createLabel() {
        JLabel l = new JLabel();
        l.setText(this.optionType.getLabel());
        l.setDisplayedMnemonic(this.optionType.getMnemonic());
        if (this.optionType.getLabelTip() != null) {
            l.setToolTipText(this.optionType.getLabelTip());
        }
        return l;
    }

    public Option getOption() {
        return this.optionType;
    }

    public String getValue() {
        return this.currValue;
    }

    protected abstract String getValueFromUI();

    protected abstract void updateUI();

    public abstract void addTo(JPanel var1);

    public void cancelChanges() {
        String prevValue = this.currValue;
        this.currValue = this.getValueFromUI();
        if (this.currValue.equals(prevValue)) {
            return;
        }
        this.setValue(prevValue);
    }

    public void applyChanges() {
        String prevValue = this.currValue;
        this.currValue = this.getValueFromUI();
        if (this.currValue.equals(prevValue)) {
            return;
        }
        if (this.value == null) {
            System.out.println("OptionUI: No value bound for " + this.optionType.getName());
        } else {
            this.value.set(this.currValue);
        }
    }

    protected void setValue(String newValue) {
        this.currValue = newValue;
        this.updateUI();
    }

    public static OptionUI createSubPanel(OptionUI[] optionUIS, CatalogDynamic catalog, String titleResource) {
        String title = catalog.get("SPT_" + titleResource);
        return new SubcategoryOptionUI(optionUIS, title);
    }

    public static void fillPanel(JPanel panel, OptionUI[] optionPanels) {
        panel.setLayout(new GridBagLayout());
        for (int i = 0; i < optionPanels.length; ++i) {
            optionPanels[i].addTo(panel);
        }
        JPanel yAbsorber = new JPanel();
        yAbsorber.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        panel.add((Component)yAbsorber, gridBagConstraints);
    }
}

