/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class MacroExpansionViewUtils {
    public static final String MACRO_EXPANSION_START_OFFSET = "macro-expansion-start-offset";
    public static final String MACRO_EXPANSION_END_OFFSET = "macro-expansion-end-offset";
    public static final String CND_EDITOR_COMPONENT = "CND_EDITOR_COMPONENT";

    public static void updateView(Document mainDoc, int newOffset, CsmFile csmFile, AtomicBoolean canceled, final Runnable syncPositions) {
        Document newExpandedContextDoc;
        CsmScope scope;
        if (!MacroExpansionTopComponent.isSyncCaretAndContext()) {
            return;
        }
        final MacroExpansionTopComponent view = MacroExpansionTopComponent.getInstance();
        if (view == null) {
            return;
        }
        Document expandedContextDoc = view.getExpandedContextDoc();
        if (expandedContextDoc == null) {
            return;
        }
        if (csmFile == null) {
            return;
        }
        int startOffset = 0;
        int endOffset = mainDoc.getLength();
        boolean localContext = MacroExpansionTopComponent.isLocalContext();
        if (localContext && CsmKindUtilities.isOffsetable((Object)(scope = ContextUtils.findInnerFileScope(csmFile, newOffset)))) {
            startOffset = ((CsmOffsetable)scope).getStartOffset();
            endOffset = ((CsmOffsetable)scope).getEndOffset();
        }
        if (canceled.get()) {
            return;
        }
        Document doc = (Document)expandedContextDoc.getProperty(Document.class);
        if (mainDoc.equals(doc) && !MacroExpansionViewUtils.isOffsetChanged(expandedContextDoc, startOffset, endOffset)) {
            SwingUtilities.invokeLater(syncPositions);
        }
        if ((newExpandedContextDoc = MacroExpansionViewUtils.createExpandedContextDocument(mainDoc, csmFile)) == null) {
            return;
        }
        final int expansionsNumber = CsmMacroExpansion.expand((Document)mainDoc, (int)startOffset, (int)endOffset, (Document)newExpandedContextDoc, (AtomicBoolean)canceled);
        if (canceled.get()) {
            return;
        }
        MacroExpansionViewUtils.setOffset(newExpandedContextDoc, startOffset, endOffset);
        MacroExpansionViewUtils.saveDocumentAndMarkAsReadOnly(newExpandedContextDoc);
        Runnable openView = new Runnable(){

            @Override
            public void run() {
                if (!view.isOpened()) {
                    view.open();
                }
                view.setDocuments(newExpandedContextDoc);
                view.setStatusBarText(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionStatusBarLine", (Object)expansionsNumber));
                syncPositions.run();
            }
        };
        SwingUtilities.invokeLater(openView);
    }

    private static boolean isOffsetChanged(Document doc, int startOffset, int endOffset) {
        int oldStartOffset = 0;
        int oldEndOffset = 0;
        Object obj = doc.getProperty(MACRO_EXPANSION_START_OFFSET);
        if (obj instanceof Integer) {
            oldStartOffset = (Integer)obj;
        }
        if ((obj = doc.getProperty(MACRO_EXPANSION_END_OFFSET)) instanceof Integer) {
            oldEndOffset = (Integer)obj;
        }
        return oldStartOffset != startOffset || oldEndOffset != endOffset;
    }

    public static void setOffset(Document doc, int startOffset, int endOffset) {
        doc.putProperty(MACRO_EXPANSION_START_OFFSET, startOffset);
        doc.putProperty(MACRO_EXPANSION_END_OFFSET, endOffset);
    }

    public static Document createExpandedContextDocument(Document mainDoc, CsmFile csmFile) {
        FileObject fobj = MacroExpansionViewUtils.createMemoryFile(MacroExpansionViewUtils.getDocumentName(mainDoc));
        if (fobj == null) {
            return null;
        }
        Document doc = MacroExpansionViewUtils.openFileDocument(fobj);
        if (doc == null) {
            return null;
        }
        doc.putProperty("title", mainDoc.getProperty("title"));
        doc.putProperty(CsmFile.class, csmFile);
        doc.putProperty(FileObject.class, fobj);
        doc.putProperty("beforeSaveRunnable", null);
        doc.putProperty("macro-expansion-view-document", true);
        MacroExpansionViewUtils.closeMemoryBasedDocument((Document)mainDoc.getProperty(Document.class));
        mainDoc.putProperty(Document.class, doc);
        doc.putProperty(Document.class, mainDoc);
        MacroExpansionViewUtils.setupMimeType(doc, mainDoc);
        return doc;
    }

    public static int getFileOffset(Document doc, int documentOffset) {
        return CsmMacroExpansion.getOffsetInOriginalText((Document)doc, (int)documentOffset);
    }

    public static int getDocumentOffset(Document doc, int fileOffset) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)doc, (int)fileOffset);
    }

    public static JEditorPane getEditor(Document doc) {
        Object jEditorPane = doc.getProperty(JEditorPane.class);
        if (jEditorPane != null) {
            return (JEditorPane)jEditorPane;
        }
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (dobj != null) {
            EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            return ec == null ? null : CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)ec);
        }
        return null;
    }

    public static void setupMimeType(Document doc, Document mainDoc) {
        String mimeType = DocumentUtilities.getMimeType((Document)mainDoc);
        if (mimeType != null) {
            if (MIMENames.isHeaderOrCppOrC((String)mimeType)) {
                doc.putProperty("mimeType", mimeType);
            } else {
                doc.putProperty("mimeType", "text/x-c++");
            }
        } else {
            doc.putProperty("mimeType", "text/x-c++");
        }
    }

    public static FileObject createMemoryFile(String name) {
        FileObject fo = null;
        try {
            FileObject root = FileUtil.createMemoryFileSystem().getRoot();
            fo = FileUtil.createData((FileObject)root, (String)name);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fo;
    }

    public static Document openFileDocument(FileObject fo) {
        StyledDocument doc = null;
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            doc = CsmUtilities.openDocument((EditorCookie)ec);
            if (doc != null) {
                doc.putProperty("stream", dob);
            }
        }
        catch (DataObjectNotFoundException dob) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return doc;
    }

    public static void closeMemoryBasedDocument(Document doc) {
        DataObject dob;
        if (doc != null && doc.getProperty("macro-expansion-view-document") != null && (dob = (DataObject)doc.getProperty("stream")) != null) {
            FileObject primaryFile;
            CloseCookie closeCookie = (CloseCookie)dob.getLookup().lookup(CloseCookie.class);
            if (closeCookie != null) {
                closeCookie.close();
            }
            if ((primaryFile = dob.getPrimaryFile()) != null && primaryFile.isValid() && !primaryFile.isLocked()) {
                assert (primaryFile.equals(doc.getProperty(FileObject.class)));
                try {
                    primaryFile.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public static void saveDocumentAndMarkAsReadOnly(Document doc) {
        FileObject fo = CsmUtilities.getFileObject((Document)doc);
        if (fo != null && fo.isValid()) {
            MacroExpansionViewUtils.saveFileAndMarkAsReadOnly(fo);
        }
    }

    private static void saveFileAndMarkAsReadOnly(FileObject fo) {
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            ec.saveDocument();
            ReadOnlySupport ro = (ReadOnlySupport)dob.getLookup().lookup(ReadOnlySupport.class);
            if (ro != null) {
                ro.setReadOnly(true);
            }
        }
        catch (DataObjectNotFoundException dob) {
        }
        catch (FileStateInvalidException dob) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String getDocumentName(Document bDoc) {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)bDoc);
        if (dobj != null && dobj.isValid()) {
            FileObject fo = dobj.getPrimaryFile();
            return fo.getNameExt();
        }
        Object title = bDoc.getProperty("title");
        if (title instanceof String) {
            return (String)title;
        }
        return "MacroView";
    }

    public static void lockFile(FileObject fo) {
        try {
            fo.lock();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

