/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class ShowMacroExpansionAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        Document mainDoc = this.getDocument(activatedNodes);
        int offset = this.getOffset(activatedNodes);
        CsmMacroExpansion.showMacroExpansionView((Document)mainDoc, (int)offset);
    }

    private Document getDocument(Node[] activatedNodes) {
        EditorCookie c = (EditorCookie)activatedNodes[0].getLookup().lookup(EditorCookie.class);
        if (c != null) {
            return CsmUtilities.openDocument((EditorCookie)c);
        }
        return null;
    }

    private int getOffset(Node[] activatedNodes) {
        JEditorPane pane;
        EditorCookie c = (EditorCookie)activatedNodes[0].getLookup().lookup(EditorCookie.class);
        if (c != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)c)) != null) {
            return pane.getCaret().getDot();
        }
        return 0;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length > 0) {
            return ContextUtils.findFile(activatedNodes[0]) != null;
        }
        return false;
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowMacroExpansionAction");
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

