/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;

class HierarchyModelImpl
implements HierarchyModel {
    private Map<CsmClass, Set<CsmClass>> myMap;
    private Action close;
    private final Action[] actions;
    private final boolean subDirection;
    private final boolean plain;
    private final boolean recursive;
    private final CsmClass startClass;

    public HierarchyModelImpl(CsmClass cls, Action[] actions, boolean subDirection, boolean plain, boolean recursive) {
        this.actions = actions;
        this.subDirection = subDirection;
        this.plain = plain;
        this.recursive = recursive;
        this.startClass = cls;
        if (!subDirection) {
            Set<CsmClass> result;
            this.myMap = this.buildSuperHierarchy(cls);
            if (!recursive) {
                result = this.myMap.get(cls);
                if (result == null) {
                    result = new HashSet<CsmClass>();
                }
                this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
                this.myMap.put(cls, result);
            }
            if (plain) {
                result = new HashSet<CsmClass>();
                this.gatherList(cls, result, this.myMap);
                this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
                this.myMap.put(cls, result);
            }
        }
    }

    @Override
    public Collection<CsmClass> getHierarchy(CsmClass cls) {
        CsmCacheManager.enter();
        try {
            Collection<CsmClass> collection = this.getHierarchyImpl(cls);
            return collection;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private Collection<CsmClass> getHierarchyImpl(CsmClass cls) {
        if (this.subDirection) {
            Collection<Object> subRefs = Collections.emptyList();
            if (this.plain && this.recursive) {
                if (this.startClass.equals(cls)) {
                    subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false);
                }
            } else if (!this.plain && this.recursive) {
                subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, true);
            } else if (this.plain && !this.recursive) {
                if (this.startClass.equals(cls)) {
                    subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, true);
                }
            } else if (!this.plain && !this.recursive && this.startClass.equals(cls)) {
                subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, true);
            }
            if (!subRefs.isEmpty()) {
                ArrayList<CsmClass> subClasses = new ArrayList<CsmClass>(subRefs.size());
                for (CsmReference csmReference : subRefs) {
                    CsmObject obj = csmReference.getReferencedObject();
                    if (!(obj instanceof CsmClass)) continue;
                    subClasses.add((CsmClass)obj);
                }
                return subClasses;
            }
            return Collections.emptyList();
        }
        return this.myMap.get(cls);
    }

    private void gatherList(CsmClass cls, Set<CsmClass> result, Map<CsmClass, Set<CsmClass>> map) {
        Set<CsmClass> set = map.get(cls);
        if (set == null) {
            return;
        }
        for (CsmClass c : set) {
            if (result.contains(c)) continue;
            result.add(c);
            this.gatherList(c, result, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CsmClass, Set<CsmClass>> buildSuperHierarchy(CsmClass cls) {
        CsmCacheManager.enter();
        try {
            HashMap<CsmClass, Set<CsmClass>> aMap = new HashMap<CsmClass, Set<CsmClass>>();
            this.buildSuperHierarchy(cls, aMap);
            HashMap<CsmClass, Set<CsmClass>> hashMap = aMap;
            return hashMap;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private CsmClass getClassDeclaration(CsmInheritance inh) {
        CsmOffsetableDeclaration d;
        CsmClass c = CsmInheritanceUtilities.getCsmClass((CsmInheritance)inh);
        if (CsmKindUtilities.isInstantiation((CsmObject)c) && CsmKindUtilities.isClass((CsmObject)(d = ((CsmInstantiation)c).getTemplateDeclaration()))) {
            c = (CsmClass)d;
        }
        return c;
    }

    private void buildSuperHierarchy(CsmClass cls, Map<CsmClass, Set<CsmClass>> map) {
        Set<CsmClass> back = map.get(cls);
        if (back != null) {
            return;
        }
        back = new HashSet<CsmClass>();
        map.put(cls, back);
        Collection list = cls.getBaseClasses();
        if (list != null && list.size() > 0) {
            for (CsmInheritance inh : list) {
                CsmClass c = this.getClassDeclaration(inh);
                if (c == null) continue;
                back.add(c);
                this.buildSuperHierarchy(c, map);
            }
        }
    }

    @Override
    public Action[] getDefaultActions() {
        return this.actions;
    }

    @Override
    public Action getCloseWindowAction() {
        return this.close;
    }

    @Override
    public void setCloseWindowAction(Action close) {
        this.close = close;
    }
}

