/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.uint$ref;

public abstract class StdMapTypeUInt<KeyT>
implements Native.assignable<std.mapTypeUInt<KeyT>>,
NativeCloneable<std.mapTypeUInt<KeyT>>,
Iterable<std_pair.pairTypeUInt<KeyT>>,
Destructors.ClassWithDestructor {
    protected int defaultValue;
    protected TreeMap<KeyT, std_pair.pairTypeUInt<KeyT>> treeMap;

    protected StdMapTypeUInt(int defaultValue) {
        this(null, defaultValue);
    }

    protected StdMapTypeUInt(Comparator<KeyT> comparator, int defaultValue) {
        this.treeMap = new TreeMap(comparator != null ? comparator : new DefaultComparator());
        this.defaultValue = defaultValue;
    }

    protected StdMapTypeUInt(std.mapTypeUInt<KeyT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    @Override
    public std.mapTypeUInt<KeyT> $assign(std.mapTypeUInt<KeyT> other) {
        this.clear();
        for (Map.Entry entry : other.treeMap.entrySet()) {
            this.treeMap.put(entry.getKey(), std.make_pair_T_uint(entry.getKey(), this.isDataPointerLike() ? ((std_pair.pairTypeUInt)entry.getValue()).second : Native.$tryClone(((std_pair.pairTypeUInt)entry.getValue()).second)));
        }
        return (std.mapTypeUInt)this;
    }

    public void swap(std.mapTypeUInt<KeyT> other) {
        TreeMap<KeyT, std_pair.pairTypeUInt<KeyT>> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        int tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public int $at(KeyT key) {
        std_pair.pairTypeUInt<KeyT> out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair_T_uint(key, Native.$tryClone(this.defaultValue));
            this.treeMap.put(key, out);
        }
        return out.second;
    }

    public void $set(KeyT key, int val) {
        this.treeMap.put(key, std.make_pair_T_uint(key, this.isDataPointerLike() ? val : Native.$tryClone(val)));
    }

    public uint$ref ref$at(final KeyT key) {
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(key, std.make_pair_T_uint(key, Native.$tryClone(this.defaultValue)));
        }
        return new uint$ref(){

            @Override
            public int $deref() {
                return StdMapTypeUInt.this.treeMap.get((Object)key).second;
            }

            @Override
            public int $set(int value) {
                StdMapTypeUInt.this.treeMap.get((Object)key).second = StdMapTypeUInt.this.isDataPointerLike() ? value : Native.$tryClone(value);
                return value;
            }

            @Override
            public uint$ptr deref$ptr() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        return this.treeMap.size();
    }

    public boolean empty() {
        return this.treeMap.isEmpty();
    }

    public void clear() {
        if (!this.isDataPointerLike()) {
            for (Map.Entry<KeyT, std_pair.pairTypeUInt<KeyT>> entry : this.treeMap.entrySet()) {
                Native.destroy(entry.getValue().second);
            }
        }
        this.treeMap.clear();
    }

    public std_pair.pairTypeBool<iterator<KeyT>> insert(std_pair.pairTypeUInt<KeyT> val) {
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(val.first, std.make_pair_T_uint(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
        return std.make_pair_T_bool(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std_pair.pairTypeUInt<KeyT>> I, type$iterator<?, std_pair.pairTypeUInt<KeyT>> E) {
        while (Native.$noteq_iter(I, E)) {
            std_pair.pairTypeUInt<KeyT> val = I.$star();
            this.treeMap.put(val.first, std.make_pair_T_uint(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
            I.$preInc();
        }
    }

    public void erase(iterator<KeyT> position) {
        if (!this.isDataPointerLike()) {
            Native.destroy(((std_pair.pairTypeUInt)position.$star()).second);
        }
        ((iterator)position).erase();
    }

    public boolean erase(KeyT key) {
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        if (!this.isDataPointerLike()) {
            Native.destroy(this.treeMap.get(key).second);
        }
        this.treeMap.remove(key);
        return true;
    }

    public iterator<KeyT> lower_bound(KeyT key) {
        KeyT lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator<KeyT> upper_bound(KeyT key) {
        iterator<KeyT> upperBound = this.lower_bound(key);
        while (upperBound.$noteq(this.end()) && this.treeMap.comparator().compare(key, ((iterator)upperBound).getKey()) >= 0) {
            upperBound.$preInc();
        }
        return upperBound;
    }

    public iterator<KeyT> begin() {
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator<KeyT> end() {
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    @Override
    public Iterator<std_pair.pairTypeUInt<KeyT>> iterator() {
        return new JavaIterator<std_pair.pairTypeUInt<KeyT>>(this.begin(), this.end());
    }

    public boolean count(KeyT key) {
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(KeyT key, int val) {
        std_pair.pairTypeUInt<KeyT> entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public iterator<KeyT> find(KeyT key) {
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        Comparator<KeyT> comparator = this.treeMap.comparator();
        iterator<KeyT> I = this.begin();
        iterator<KeyT> E = this.end();
        while (I.$noteq(E)) {
            if (comparator.compare(((iterator)I).getKey(), key) == 0) {
                return I;
            }
            I.$preInc();
        }
        throw new AssertionError((Object)"Why not found???");
    }

    @Override
    public std.mapTypeUInt<KeyT> clone() {
        return new std.mapTypeUInt((std.mapTypeUInt)this);
    }

    @Override
    public void $destroy() {
        this.clear();
    }

    private boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        return "StdMapTypeUInt{" + this.treeMap + "}";
    }

    public static class iterator<KeyT>
    implements type$iterator<iterator<KeyT>, std_pair.pairTypeUInt<KeyT>> {
        private final int defaultValue;
        private final TreeMap<KeyT, std_pair.pairTypeUInt<KeyT>> map;
        private final boolean _const;
        private Map.Entry<KeyT, std_pair.pairTypeUInt<KeyT>> currentEntry;

        private iterator(TreeMap<KeyT, std_pair.pairTypeUInt<KeyT>> map2, Map.Entry<KeyT, std_pair.pairTypeUInt<KeyT>> curr, int defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map2;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private KeyT getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        @Override
        public std_pair.pairTypeUInt<KeyT> $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std_pair.pairTypeUInt<KeyT> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std_pair.pairTypeUInt<KeyT>> star$ref() {
            return new type$ref<std_pair.pairTypeUInt<KeyT>>(){
                private final Map.Entry<KeyT, std_pair.pairTypeUInt<KeyT>> localEntry;
                {
                    this.localEntry = currentEntry;
                }

                @Override
                public std_pair.pairTypeUInt<KeyT> $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std_pair.pairTypeUInt<KeyT> $set(std_pair.pairTypeUInt<KeyT> value) {
                    assert (map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std_pair.pairTypeUInt<KeyT>> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator<KeyT> $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT> $postInc() {
            Object cloned = this.clone();
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator<KeyT> clone() {
            return new iterator<KeyT>(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator<KeyT> const_clone() {
            return new iterator<KeyT>(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator<KeyT> iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT> $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT> $postDec() {
            Object cloned = this.clone();
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator<KeyT> $inc(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT> $dec(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT> $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT> $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return false;
        }
    }

    private static class DefaultComparator<KeyT>
    implements Comparator<KeyT> {
        private DefaultComparator() {
        }

        @Override
        public int compare(KeyT o1, KeyT o2) {
            if (o1 instanceof Native.ComparableLower) {
                if (((Native.ComparableLower)o1).$less(o2)) {
                    return -1;
                }
                return ((Native.ComparableLower)o2).$less(o1) ? 1 : 0;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            throw new UnsupportedOperationException("NO ComparableLower: " + o1.getClass() + " vs. " + o2.getClass());
        }
    }
}

