/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class CollectionUtils {
    public static <F, T> T[] transform(F[] from, Converter<F, T> converter, boolean nullTerminate) {
        Object[] to = (Object[])Array.newInstance(converter.getToClass(), from.length + (nullTerminate ? 1 : 0));
        for (int i = 0; i < from.length; ++i) {
            to[i] = converter.convert(from[i]);
        }
        if (nullTerminate) {
            to[to.length - 1] = null;
        }
        return to;
    }

    public static <F, T> List<T> transform(List<F> from, Converter<F, T> converter, boolean nullTerminate) {
        ArrayList<T> to = new ArrayList<T>(from.size() + (nullTerminate ? 1 : 0));
        for (F f : from) {
            to.add(converter.convert(f));
        }
        if (nullTerminate) {
            to.add(null);
        }
        return to;
    }

    @FunctionalInterface
    public static interface Converter<F, T> {
        default public Class<T> getToClass() {
            throw new UnsupportedOperationException();
        }

        public T convert(F var1);
    }
}

