/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.ulong$ptr;
import org.clank.support.aliases.ulong$ref;
import org.clank.support.void$ptr;

public final class ulong$ptr$array
extends AbstractArrayPointerType<ulong$ptr>
implements ulong$ptr {
    protected long[] array;
    private static long nonConstInstances = 0L;
    private static long constPtrInstances = 0L;
    private static long constContentInstances = 0L;
    private static long fullyConstInstances = 0L;

    protected ulong$ptr$array(ulong$ptr$array other, boolean makeConstPtr, boolean makeConstContent) {
        super(other, makeConstPtr, makeConstContent);
        this.array = other.array;
        ulong$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    public ulong$ptr$array() {
        this(null, 0, false, false);
    }

    public ulong$ptr$array(long[] arr) {
        this(arr, 0, false, false);
    }

    public ulong$ptr$array(long[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public ulong$ptr$array(long[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public ulong$ptr$array(long[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public ulong$ptr$array(long[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, makeConstContent);
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        ulong$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public long $star() {
        return this.array[this.index];
    }

    @Override
    public long $set(long value) {
        return this.$set(0, value);
    }

    @Override
    public long $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public int $sub(ulong$ptr other) {
        assert (other instanceof ulong$ptr$array) : "unexpected object " + other;
        return this.index - ((ulong$ptr$array)other).index;
    }

    @Override
    public ulong$ptr$array $add(int amount) {
        ulong$ptr$array cloned = new ulong$ptr$array(this, false, this._isConstContent());
        cloned.index += amount;
        return cloned;
    }

    @Override
    public ulong$ptr$array $sub(int amount) {
        ulong$ptr$array cloned = new ulong$ptr$array(this, false, this._isConstContent());
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public long $set(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        long l = value;
        this.array[this.index + index] = l;
        return l;
    }

    @Override
    public long $set$andassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] & value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$xorassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] ^ value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$orassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] | value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$addassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] + value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$minusassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] - value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$starassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] * value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$slashassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] / value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$modassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] % value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$lshiftassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] << (int)value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$rshiftassign(int index, long value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] >> (int)value;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$postInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n];
        this.array[n] = l + 1L;
        return l;
    }

    @Override
    public long $set$postDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n];
        this.array[n] = l - 1L;
        return l;
    }

    @Override
    public long $set$preInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] + 1L;
        this.array[n] = l;
        return l;
    }

    @Override
    public long $set$preDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        long l = this.array[n] - 1L;
        this.array[n] = l;
        return l;
    }

    @Override
    public ulong$ptr $assign(ulong$ptr value) {
        assert (!this._isConstPtr()) : "Cannot modify const object!";
        if (value instanceof ulong$ptr$array) {
            ulong$ptr$array val = (ulong$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "', but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof ulong$ptr$array && ((ulong$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof ulong$ptr$array) {
            ulong$ptr$array other = (ulong$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof ulong$ptr$array) {
            ulong$ptr$array other = (ulong$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof ulong$ptr$array) {
            ulong$ptr$array other = (ulong$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof ulong$ptr$array) {
            ulong$ptr$array other = (ulong$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof ulong$ptr$array) {
            ulong$ptr$array other = (ulong$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public ulong$ref star$ref() {
        return new ulong$ref(){
            ulong$ptr$array localPtr;
            {
                this.localPtr = ulong$ptr$array.this;
            }

            @Override
            public long $deref() {
                return this.localPtr.$star();
            }

            @Override
            public long $set(long value) {
                return this.localPtr.$set(value);
            }

            @Override
            public ulong$ptr deref$ptr() {
                if (this.localPtr == ulong$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return System.identityHashCode(this.array) ^ this.index;
    }

    @Override
    public ulong$ptr$array clone() {
        return new ulong$ptr$array(this, false, this._isConstContent());
    }

    @Override
    public ulong$ptr$array const_clone() {
        return super._isConstPtr() ? this : new ulong$ptr$array(this, true, this._isConstContent());
    }

    public String toString() {
        if (this.array == null || this.array.length == 0) {
            return "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder("\n" + ulong$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            long b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(ulong$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                ++fullyConstInstances;
            } else if (constPtr) {
                ++constPtrInstances;
            } else if (constContent) {
                ++constContentInstances;
            } else {
                ++nonConstInstances;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0L;
        constPtrInstances = 0L;
        constContentInstances = 0L;
        nonConstInstances = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", ulong$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", ulong$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", ulong$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", ulong$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", ulong$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }

    @Override
    public final long[] $array() {
        return this.array;
    }
}

