/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.util.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAWSSigner
implements Signer {
    private static final String DEFAULT_ENCODING = "UTF-8";

    protected String sign(String data, String key, SigningAlgorithm algorithm) throws AmazonClientException {
        try {
            return this.sign(data.getBytes(DEFAULT_ENCODING), key, algorithm);
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected String sign(byte[] data, String key, SigningAlgorithm algorithm) throws AmazonClientException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key.getBytes(), algorithm.toString()));
            byte[] signature = Base64.encodeBase64((byte[])mac.doFinal(data));
            return new String(signature);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        StringBuilder builder = new StringBuilder();
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            String value = (String)pair.getValue();
            builder.append(HttpUtils.urlEncode(key, false));
            builder.append("=");
            builder.append(HttpUtils.urlEncode(value, false));
            if (!pairs.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    protected String getCanonicalizedResourcePath(URI endpoint) {
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            return "/";
        }
        return HttpUtils.urlEncode(uri, true);
    }

    protected String getCanonicalizedEndpoint(URI endpoint) {
        String endpointForStringToSign = endpoint.getHost().toLowerCase();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            endpointForStringToSign = endpointForStringToSign + ":" + endpoint.getPort();
        }
        return endpointForStringToSign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWSCredentials sanitizeCredentials(AWSCredentials credentials) {
        String accessKeyId = null;
        String secretKey = null;
        AWSCredentials aWSCredentials = credentials;
        synchronized (aWSCredentials) {
            accessKeyId = credentials.getAWSAccessKeyId();
            secretKey = credentials.getAWSSecretKey();
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (accessKeyId != null) {
            accessKeyId = accessKeyId.trim();
        }
        return new BasicAWSCredentials(accessKeyId, secretKey);
    }
}

