/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeAlarmsRequestMarshaller
implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {
    @Override
    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {
        DefaultRequest<DescribeAlarmsRequest> request = new DefaultRequest<DescribeAlarmsRequest>(describeAlarmsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        if (describeAlarmsRequest != null) {
            List<String> alarmNamesList = describeAlarmsRequest.getAlarmNames();
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString(alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        if (describeAlarmsRequest != null && describeAlarmsRequest.getAlarmNamePrefix() != null) {
            request.addParameter("AlarmNamePrefix", StringUtils.fromString(describeAlarmsRequest.getAlarmNamePrefix()));
        }
        if (describeAlarmsRequest != null && describeAlarmsRequest.getStateValue() != null) {
            request.addParameter("StateValue", StringUtils.fromString(describeAlarmsRequest.getStateValue()));
        }
        if (describeAlarmsRequest != null && describeAlarmsRequest.getActionPrefix() != null) {
            request.addParameter("ActionPrefix", StringUtils.fromString(describeAlarmsRequest.getActionPrefix()));
        }
        if (describeAlarmsRequest != null && describeAlarmsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeAlarmsRequest.getMaxRecords()));
        }
        if (describeAlarmsRequest != null && describeAlarmsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeAlarmsRequest.getNextToken()));
        }
        return request;
    }
}

