/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceAsync;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticMapReduceAsyncClient
extends AmazonElasticMapReduceClient
implements AmazonElasticMapReduceAsync {
    private ExecutorService executorService;

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddInstanceGroupsResult> addInstanceGroupsAsync(final AddInstanceGroupsRequest addInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddInstanceGroupsResult>(){

            @Override
            public AddInstanceGroupsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.addInstanceGroups(addInstanceGroupsRequest);
            }
        });
    }

    @Override
    public Future<Void> addJobFlowStepsAsync(final AddJobFlowStepsRequest addJobFlowStepsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.addJobFlowSteps(addJobFlowStepsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> terminateJobFlowsAsync(final TerminateJobFlowsRequest terminateJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.terminateJobFlows(terminateJobFlowsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync(final DescribeJobFlowsRequest describeJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeJobFlowsResult>(){

            @Override
            public DescribeJobFlowsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.describeJobFlows(describeJobFlowsRequest);
            }
        });
    }

    @Override
    public Future<Void> setTerminationProtectionAsync(final SetTerminationProtectionRequest setTerminationProtectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.setTerminationProtection(setTerminationProtectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<RunJobFlowResult> runJobFlowAsync(final RunJobFlowRequest runJobFlowRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunJobFlowResult>(){

            @Override
            public RunJobFlowResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.runJobFlow(runJobFlowRequest);
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync(final ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.modifyInstanceGroups(modifyInstanceGroupsRequest);
                return null;
            }
        });
    }
}

