/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonInstanceProperties;
import org.netbeans.modules.hudson.spi.HudsonManagerAgent;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class HudsonManagerImpl {
    private static final RequestProcessor RP = new RequestProcessor(HudsonManagerImpl.class);
    private static HudsonManagerImpl defaultInstance;
    private Map<String, HudsonInstanceImpl> instances;
    private final List<HudsonChangeListener> listeners = new ArrayList<HudsonChangeListener>();
    private final Collection<? extends HudsonManagerAgent> agents = Lookup.getDefault().lookupAll(HudsonManagerAgent.class);

    private HudsonManagerImpl() {
    }

    public static synchronized HudsonManagerImpl getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new HudsonManagerImpl();
        }
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HudsonInstanceImpl addInstance(HudsonInstanceImpl instance) {
        HudsonManagerImpl hudsonManagerImpl = this;
        synchronized (hudsonManagerImpl) {
            if (null == instance || null != this.getInstancesMap().get(instance.getUrl())) {
                return null;
            }
            if (null != this.getInstancesMap().put(instance.getUrl(), instance)) {
                return null;
            }
        }
        for (HudsonManagerAgent hudsonManagerAgent : this.agents) {
            hudsonManagerAgent.instanceAdded(instance);
        }
        this.fireChangeListeners();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HudsonInstanceImpl removeInstance(HudsonInstanceImpl instance) {
        HudsonManagerImpl hudsonManagerImpl = this;
        synchronized (hudsonManagerImpl) {
            if (null == instance || null == this.getInstancesMap().get(instance.getUrl())) {
                return null;
            }
            if (null == this.getInstancesMap().remove(instance.getUrl())) {
                return null;
            }
        }
        instance.terminate();
        for (HudsonManagerAgent hudsonManagerAgent : this.agents) {
            hudsonManagerAgent.instanceRemoved(instance);
        }
        this.fireChangeListeners();
        if (instance.isPersisted()) {
            this.removeInstanceDefinition(instance);
        }
        return instance;
    }

    public synchronized HudsonInstanceImpl getInstance(String url) {
        return this.getInstancesMap().get(url);
    }

    public synchronized Collection<HudsonInstanceImpl> getInstances() {
        return Arrays.asList(this.getInstancesMap().values().toArray(new HudsonInstanceImpl[0]));
    }

    public HudsonInstance getInstanceByName(String name) {
        for (HudsonInstance hudsonInstance : this.getInstances()) {
            if (!hudsonInstance.getName().equals(name)) continue;
            return hudsonInstance;
        }
        return null;
    }

    public void addHudsonChangeListener(HudsonChangeListener l) {
        this.listeners.add(l);
    }

    public void removeHudsonChangeListener(HudsonChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListeners() {
        ArrayList<HudsonChangeListener> tempList;
        List<HudsonChangeListener> list = this.listeners;
        synchronized (list) {
            tempList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener l : tempList) {
            l.stateChanged();
            l.contentChanged();
        }
    }

    public void terminate() {
        defaultInstance = null;
        for (HudsonManagerAgent hudsonManagerAgent : this.agents) {
            hudsonManagerAgent.terminate();
        }
        for (HudsonInstance hudsonInstance : this.getInstances()) {
            ((HudsonInstanceImpl)hudsonInstance).terminate();
        }
    }

    static Preferences instancePrefs() {
        return NbPreferences.forModule(HudsonManagerImpl.class).node("instances");
    }

    public static String simplifyServerLocation(String name, boolean forKey) {
        String display = name.replaceFirst("https?://", "").replaceFirst("/$", "");
        return forKey ? display.replaceAll("[/:]", "_") : display;
    }

    private void removeInstanceDefinition(HudsonInstanceImpl instance) {
        try {
            instance.prefs().removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Map<String, HudsonInstanceImpl> getInstancesMap() {
        if (null == this.instances) {
            this.instances = new HashMap<String, HudsonInstanceImpl>();
            this.init();
        }
        return this.instances;
    }

    private void init() {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        for (String kid : HudsonManagerImpl.instancePrefs().childrenNames()) {
                            Preferences node = HudsonManagerImpl.instancePrefs().node(kid);
                            HashMap<String, String> m = new HashMap<String, String>();
                            for (String k : node.keys()) {
                                m.put(k, node.get(k, null));
                            }
                            if (!m.containsKey("name") || !m.containsKey("url") || !m.containsKey("sync_time") || "false".equals(m.get("persisted"))) continue;
                            HudsonInstanceImpl.createHudsonInstance(new HudsonInstanceProperties((Map<String, String>)m), false);
                        }
                    }
                    catch (BackingStoreException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                finally {
                    HudsonManagerImpl.this.fireChangeListeners();
                }
            }
        });
        for (HudsonManagerAgent hudsonManagerAgent : this.agents) {
            hudsonManagerAgent.start();
        }
    }
}

