/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.pim;

import java.util.Date;
import java.util.Enumeration;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.ToDoList;

class Query {
    public static final int STRING_TYPE = 0;
    public static final int INTEGER_TYPE = 1;
    public static final int BOOLEAN_TYPE = 2;
    public static final int DATE_TYPE = 3;

    Query() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getListCount(int pimList) {
        PIMList l = null;
        int count = 0;
        try {
            l = PIM.getInstance().openPIMList(pimList, 1);
            Enumeration list = l.items();
            while (list.hasMoreElements()) {
                list.nextElement();
                ++count;
            }
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
        finally {
            if (l != null) {
                try {
                    l.close();
                }
                catch (PIMException pIMException) {}
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupportedField(int pimList, int field) {
        PIMList todos = null;
        boolean result = false;
        try {
            todos = PIM.getInstance().openPIMList(pimList, 1);
            result = todos.isSupportedField(field);
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
        finally {
            if (todos != null) {
                try {
                    todos.close();
                }
                catch (PIMException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFieldCount(int pimList, int pimIndex, int field) {
        PIMList l = null;
        int count = 0;
        try {
            l = PIM.getInstance().openPIMList(pimList, 1);
            int i = 0;
            Enumeration list = l.items();
            while (list.hasMoreElements()) {
                PIMItem todo = (PIMItem)list.nextElement();
                if (pimIndex == i) {
                    count = todo.countValues(field);
                    break;
                }
                ++i;
            }
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
        finally {
            if (l != null) {
                try {
                    l.close();
                }
                catch (PIMException e) {}
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getField(int pimList, int pimIndex, int field, int index, int fieldType) {
        Object result;
        block21: {
            PIMList l = null;
            result = null;
            try {
                l = PIM.getInstance().openPIMList(pimList, 1);
                int i = 0;
                Enumeration list = l.items();
                while (list.hasMoreElements()) {
                    PIMItem todo = (PIMItem)list.nextElement();
                    if (index > todo.countValues(field) - 1) {
                        throw new IllegalArgumentException("Field index is out of scope : " + index);
                    }
                    if (pimIndex == i) {
                        switch (fieldType) {
                            case 0: {
                                result = todo.getString(field, index);
                                break block21;
                            }
                            case 1: {
                                result = new Integer(todo.getInt(field, index));
                                break block21;
                            }
                            case 2: {
                                result = new Boolean(todo.getBoolean(field, index));
                                break block21;
                            }
                            case 3: {
                                result = new Date(todo.getDate(field, index));
                                break block21;
                            }
                            default: {
                                throw new IllegalArgumentException("Illegal field type");
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (PIMException ex) {
                ex.printStackTrace();
            }
            finally {
                if (l != null) {
                    try {
                        l.close();
                    }
                    catch (PIMException e) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setField(int pimList, int pimIndex, int field, int index, int fieldType, Object value) {
        PIMList l = null;
        try {
            l = PIM.getInstance().openPIMList(pimList, 3);
            int i = 0;
            Enumeration list = l.items();
            while (list.hasMoreElements()) {
                PIMItem todo = (PIMItem)list.nextElement();
                if (pimIndex == i) {
                    switch (fieldType) {
                        case 0: {
                            todo.setString(field, index, 0, (String)value);
                            break;
                        }
                        case 1: {
                            todo.setInt(field, index, 0, ((Integer)value).intValue());
                            break;
                        }
                        case 2: {
                            todo.setBoolean(field, index, 0, ((Boolean)value).booleanValue());
                            break;
                        }
                        case 3: {
                            todo.setDate(field, index, 0, ((Date)value).getTime());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal field type");
                        }
                    }
                    todo.commit();
                    break;
                }
                ++i;
            }
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
        finally {
            if (l != null) {
                try {
                    l.close();
                }
                catch (PIMException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getSupportedArrayElements(int pimList, int pimIndex, int field) {
        ToDoList l = null;
        int[] result = new int[]{};
        try {
            l = (ToDoList)PIM.getInstance().openPIMList(pimList, 1);
            boolean i = false;
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
        finally {
            if (l != null) {
                try {
                    l.close();
                }
                catch (PIMException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContactArrayValue(int contactIndex, int attribute, int fieldID, int arrayFieldIndex) {
        String result = null;
        ContactList contacts = null;
        try {
            contacts = (ContactList)PIM.getInstance().openPIMList(1, 1);
            Enumeration items = contacts.items();
            int i = 0;
            while (items.hasMoreElements()) {
                Contact contact = (Contact)items.nextElement();
                if (i == contactIndex) {
                    String[] field = contact.getStringArray(fieldID, attribute);
                    result = field[arrayFieldIndex];
                    break;
                }
                ++i;
            }
        }
        catch (PIMException e) {
            e.printStackTrace();
        }
        finally {
            if (contacts != null) {
                try {
                    contacts.close();
                }
                catch (PIMException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContactArrayValue(int contactIndex, int attribute, int fieldID, int arrayFieldIndex, String value) {
        ContactList contacts = null;
        try {
            contacts = (ContactList)PIM.getInstance().openPIMList(1, 3);
            Enumeration items = contacts.items();
            int i = 0;
            while (items.hasMoreElements()) {
                Contact contact = (Contact)items.nextElement();
                if (i == contactIndex) {
                    String[] field = contact.getStringArray(fieldID, attribute);
                    field[arrayFieldIndex] = value;
                    break;
                }
                ++i;
            }
        }
        catch (PIMException e) {
            e.printStackTrace();
        }
        finally {
            if (contacts != null) {
                try {
                    contacts.close();
                }
                catch (PIMException e) {}
            }
        }
    }
}

