/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.netbeans.upgrade.AutoUpgrade;
import org.netbeans.upgrade.systemoptions.Importer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    private static OptionsImportingTask task;
    private static JProgressBar progressBar;
    private static File sourceFolder;

    private Util() {
    }

    public static void setDefaultLookAndFeel() {
        String uiClassName = Utilities.isWindows() ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (Utilities.isMac() ? "apple.laf.AquaLookAndFeel" : (Utilities.isUnix() ? "javax.swing.plaf.metal.MetalLookAndFeel" : UIManager.getSystemLookAndFeelClassName()));
        if (uiClassName.equals(UIManager.getLookAndFeel().getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(uiClassName);
        }
        catch (Exception ex) {
            System.err.println("Cannot set L&F " + uiClassName);
            System.err.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void initIcons(JDialog dialog) {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame.gif", (boolean)true));
        images.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame32.gif", (boolean)true));
        images.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame48.gif", (boolean)true));
        dialog.setIconImages(images);
    }

    public static JDialog createJOptionProgressDialog(JOptionPane p, String title, File source, JProgressBar bar) {
        progressBar = bar;
        sourceFolder = source;
        Object[] options = p.getOptions();
        JButton bYES = (JButton)options[0];
        JButton bNO = (JButton)options[1];
        OptionsListener listener = new OptionsListener(p, bYES, bNO);
        bYES.addActionListener(listener);
        bNO.addActionListener(listener);
        return Util.createJOptionDialog(p, title);
    }

    public static JDialog createJOptionDialog(final JOptionPane pane, String title) {
        final JDialog dialog = new JDialog(null, title, Dialog.ModalityType.APPLICATION_MODAL);
        if (sourceFolder != null) {
            dialog.setDefaultCloseOperation(0);
        }
        Util.initIcons(dialog);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        dialog.setResizable(false);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                if (sourceFolder != null) {
                    return;
                }
                pane.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    pane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == pane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    if (new Integer(0).equals(pane.getValue())) {
                        if (pane.getMessageType() == 0) {
                            dialog.setVisible(false);
                            task.done();
                            return;
                        }
                        ((JButton)pane.getOptions()[0]).setEnabled(false);
                        ((JButton)pane.getOptions()[1]).setEnabled(false);
                        progressBar.setVisible(true);
                        task = new OptionsImportingTask(dialog);
                        task.execute();
                    } else {
                        dialog.setVisible(false);
                    }
                }
            }
        });
        return dialog;
    }

    private static class OptionsImportingTask
    extends SwingWorker<Void, Void> {
        JDialog dialog;

        public OptionsImportingTask(JDialog d) {
            this.dialog = d;
        }

        @Override
        public Void doInBackground() throws Exception {
            progressBar.setString(NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_ImportingSettings"));
            AutoUpgrade.doCopyToUserDir(sourceFolder);
            progressBar.setString(NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_MigratingSystemOptions"));
            Importer.doImport();
            return null;
        }

        @Override
        public void done() {
            sourceFolder = null;
            this.dialog.setVisible(false);
        }
    }

    private static class OptionsListener
    implements ActionListener {
        private JOptionPane pane;
        private JButton bYES;
        private JButton bNO;

        OptionsListener(JOptionPane pane, JButton bYES, JButton bNO) {
            this.pane = pane;
            this.bYES = bYES;
            this.bNO = bNO;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.bYES) {
                this.pane.setValue(0);
            } else if (e.getSource() == this.bNO) {
                this.pane.setValue(1);
            }
        }
    }
}

