/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.options;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.UIManager;
import org.netbeans.modules.git.remote.Annotator;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.GitVCS;
import org.netbeans.modules.versioning.util.OptionsPanelColorProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AnnotationColorProvider
extends OptionsPanelColorProvider {
    private static String name;
    private static AnnotationColorProvider INSTANCE;
    private static final Color ADDED_COLOR;
    private static final Color MODIFIED_COLOR;
    private static final Color DELETED_COLOR;
    private static final Color CONFLICTED_COLOR;
    private static final Color IGNORED_COLOR;
    private static final Color TEXT_ANNOTATION_COLOR;
    public final OptionsPanelColorProvider.AnnotationFormat UP_TO_DATE_FILE = this.createAnnotationFormat("uptodate", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_UpToDate"), null, false);
    public final OptionsPanelColorProvider.AnnotationFormat UP_TO_DATE_FILE_TOOLTIP = this.createAnnotationFormat("uptodateTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_UpToDate"), null, true);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_FILE = this.createAnnotationFormat("new", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_New"), ADDED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_FILE_TOOLTIP = this.createAnnotationFormat("newTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_New"), ADDED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat ADDED_FILE = this.createAnnotationFormat("added", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Added"), ADDED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat ADDED_FILE_TOOLTIP = this.createAnnotationFormat("addedTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Added"), ADDED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_FILE = this.createAnnotationFormat("modified", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Modified"), MODIFIED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_FILE_TOOLTIP = this.createAnnotationFormat("modifiedTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Modified"), MODIFIED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_FILE = this.createAnnotationFormat("removed", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Removed"), DELETED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_FILE_TOOLTIP = this.createAnnotationFormat("removedTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Removed"), DELETED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat EXCLUDED_FILE = this.createAnnotationFormat("excluded", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Excluded"), IGNORED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat EXCLUDED_FILE_TOOLTIP = this.createAnnotationFormat("excludedTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Excluded"), IGNORED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat CONFLICT_FILE = this.createAnnotationFormat("conflict", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Conflict"), CONFLICTED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat CONFLICT_FILE_TOOLTIP = this.createAnnotationFormat("conflictTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Conflict"), CONFLICTED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat TEXT_ANNOTATION = this.createAnnotationFormat("textAnnotation", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_TextAnnotation"), TEXT_ANNOTATION_COLOR, true);

    public AnnotationColorProvider() {
        this.initColors();
    }

    public static synchronized AnnotationColorProvider getInstance() {
        if (INSTANCE == null && (INSTANCE = (AnnotationColorProvider)((Object)Lookup.getDefault().lookup(AnnotationColorProvider.class))) == null) {
            INSTANCE = new AnnotationColorProvider();
        }
        return INSTANCE;
    }

    public String getName() {
        return GitVCS.getDisplayName();
    }

    protected Color getSavedColor(String key, Color defaultColor) {
        return GitModuleConfig.getDefault().getColor(key, defaultColor);
    }

    protected MessageFormat createFormat(Color color, boolean isTooltip) {
        StringBuilder annotationFormatString = new StringBuilder("{0}");
        if (color != null) {
            annotationFormatString = new StringBuilder("<font color=\"#").append(AnnotationColorProvider.to2Hex((int)color.getRed())).append(AnnotationColorProvider.to2Hex((int)color.getGreen())).append(AnnotationColorProvider.to2Hex((int)color.getBlue())).append("\"").append(">{0}</font>");
        }
        if (!isTooltip) {
            annotationFormatString.append("{1}");
        }
        return new MessageFormat(annotationFormatString.toString());
    }

    protected void saveColors(Collection<OptionsPanelColorProvider.AnnotationFormat> colors) {
        for (OptionsPanelColorProvider.AnnotationFormat af : colors) {
            if (af == null) continue;
            GitModuleConfig.getDefault().setColor(AnnotationColorProvider.getColorKey((String)af.getKey()), af.getActualColor());
        }
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                Git.getInstance().refreshAllAnnotations();
            }
        }, (int)0);
    }

    private void initColors() {
        this.putColor(this.ADDED_FILE);
        this.putColor(this.CONFLICT_FILE);
        this.putColor(this.EXCLUDED_FILE);
        this.putColor(this.MODIFIED_FILE);
        this.putColor(this.NEW_FILE);
        this.putColor(this.REMOVED_FILE);
        this.putColor(this.TEXT_ANNOTATION);
    }

    static {
        Color c = UIManager.getColor("nb.versioning.added.color");
        ADDED_COLOR = c == null ? new Color(0, 128, 0) : c;
        c = UIManager.getColor("nb.versioning.modified.color");
        MODIFIED_COLOR = c == null ? new Color(0, 0, 255) : c;
        c = UIManager.getColor("nb.versioning.deleted.color");
        DELETED_COLOR = c == null ? new Color(153, 153, 153) : c;
        c = UIManager.getColor("nb.versioning.conflicted.color");
        CONFLICTED_COLOR = c == null ? new Color(255, 0, 0) : c;
        c = UIManager.getColor("nb.versioning.ignored.color");
        IGNORED_COLOR = c == null ? new Color(153, 153, 153) : c;
        c = UIManager.getColor("nb.versioning.textannotation.color");
        TEXT_ANNOTATION_COLOR = c == null ? new Color(153, 153, 153) : c;
    }
}

