/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.branch;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitCherryPickResult;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRepositoryState;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.branch.Bundle;
import org.netbeans.modules.git.remote.ui.branch.CherryPick;
import org.netbeans.modules.git.remote.ui.commit.CommitAction;
import org.netbeans.modules.git.remote.ui.conflicts.ResolveConflictsExecutor;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.status.StatusAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.ResultProcessor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class CherryPickAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CherryPickAction.class.getName());

    public void cherryPick(VCSFileProxy repository, String preselectedRevision) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        GitRepositoryState state = info.getRepositoryState();
        boolean interrupted = this.isInterrupted(repository, state);
        if (state == GitRepositoryState.SAFE && !interrupted) {
            CherryPick cherryPick = new CherryPick(repository, preselectedRevision);
            if (cherryPick.showDialog()) {
                this.runCherryPick(repository, GitClient.CherryPickOperation.BEGIN, new String[]{cherryPick.getRevision()});
            }
        } else if (interrupted) {
            JButton btnContinue = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnContinue, (String)Bundle.CTL_CherryPickAction_continueButton_text());
            btnContinue.setToolTipText(Bundle.CTL_CherryPickAction_continueButton_TTtext());
            JButton btnAbort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnAbort, (String)Bundle.CTL_CherryPickAction_abortButton_text());
            btnAbort.setToolTipText(Bundle.CTL_CherryPickAction_abortButton_TTtext());
            JButton btnQuit = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnQuit, (String)Bundle.CTL_CherryPickAction_quitButton_text());
            btnQuit.setToolTipText(Bundle.CTL_CherryPickAction_quitButton_TTtext());
            HashMap<JButton, GitClient.CherryPickOperation> operations = new HashMap<JButton, GitClient.CherryPickOperation>();
            operations.put(btnContinue, GitClient.CherryPickOperation.CONTINUE);
            operations.put(btnQuit, GitClient.CherryPickOperation.QUIT);
            operations.put(btnAbort, GitClient.CherryPickOperation.ABORT);
            Object[] options = new Object[]{btnContinue, btnAbort, btnQuit, NotifyDescriptor.CANCEL_OPTION};
            Object value = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_CherryPick_cherryPickingScheduledState_text(repository.getName()), Bundle.LBL_CherryPick_cherryPickingState_title(), 1, 3, options, (Object)btnContinue));
            GitClient.CherryPickOperation op = (GitClient.CherryPickOperation)operations.get(value);
            if (op != null) {
                this.runCherryPick(repository, op, null);
            }
        } else {
            GitClientExceptionHandler.annotate(Bundle.MSG_CherryPickAction_notAllowed(state));
        }
    }

    public void finish(VCSFileProxy repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        if (this.isInterrupted(repository, info.getRepositoryState())) {
            this.cherryPick(repository, null);
        }
    }

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.cherryPick(repository, null);
    }

    private boolean isInterrupted(VCSFileProxy repository, GitRepositoryState state) {
        if (state == GitRepositoryState.CHERRY_PICKING || state == GitRepositoryState.CHERRY_PICKING_RESOLVED) {
            return true;
        }
        VCSFileProxy sequencer = VCSFileProxy.createFileProxy((VCSFileProxy)GitUtils.getGitFolderForRoot(repository), (String)"sequencer");
        VCSFileProxy[] listFiles = sequencer.listFiles();
        if (listFiles != null) {
            for (VCSFileProxy ch : listFiles) {
                if (!"todo".equals(ch.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void runCherryPick(final VCSFileProxy repository, final GitClient.CherryPickOperation op, final String[] revisions) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            GitClient client = this.getClient();
                            CherryPickResultProcessor rp = new CherryPickResultProcessor(client, repository, this.getProgressSupport());
                            GitClient.CherryPickOperation nextAction = op;
                            while (nextAction != null && !this.isCanceled()) {
                                GitCherryPickResult result = client.cherryPick(nextAction, revisions, this.getProgressMonitor());
                                rp.processResult(result, nextAction);
                                nextAction = rp.getNextAction();
                            }
                            return null;
                        }
                    }, new VCSFileProxy[0]);
                }
                catch (GitException ex) {
                    try {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    catch (Throwable throwable) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                        GitUtils.headChanged(repository);
                        throw throwable;
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                GitUtils.headChanged(repository);
            }

            private GitProgressSupport getProgressSupport() {
                return this;
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.MSG_CherryPickAction_progress());
    }

    public static class CherryPickResultProcessor
    extends ResultProcessor {
        private final OutputLogger logger;
        private GitClient.CherryPickOperation nextAction;
        private final GitProgressSupport supp;

        public CherryPickResultProcessor(GitClient client, VCSFileProxy repository, GitProgressSupport supp) {
            super(client, repository, "HEAD", supp.getProgressMonitor());
            this.logger = supp.getLogger();
            this.supp = supp;
        }

        public void processResult(GitCherryPickResult result, GitClient.CherryPickOperation currentOp) {
            this.nextAction = null;
            StringBuilder sb = new StringBuilder(Bundle.MSG_CherryPickAction_result(result.getCherryPickStatus().toString()));
            GitRevisionInfo info = result.getCurrentHead();
            switch (result.getCherryPickStatus()) {
                case ABORTED: {
                    sb.append(Bundle.MSG_CherryPickAction_result_aborted(info.getRevision()));
                    GitUtils.printInfo(sb, info);
                    break;
                }
                case FAILED: {
                    sb.append(Bundle.MSG_CherryPickAction_result_failed());
                    this.printConflicts(this.logger, sb, result.getFailures());
                    try {
                        if (this.resolveLocalChanges(result.getFailures().toArray(new VCSFileProxy[result.getFailures().size()]))) {
                            this.nextAction = GitClient.CherryPickOperation.CONTINUE;
                            break;
                        }
                        if (currentOp != GitClient.CherryPickOperation.BEGIN) break;
                        this.nextAction = GitClient.CherryPickOperation.QUIT;
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    break;
                }
                case CONFLICTING: {
                    sb.append(Bundle.MSG_CherryPickAction_result_conflict());
                    this.printConflicts(this.logger, sb, result.getConflicts());
                    this.nextAction = this.resolveCherryPickConflicts(result.getConflicts());
                    break;
                }
                case OK: {
                    sb.append(Bundle.MSG_CherryPickAction_result_ok());
                    break;
                }
                case UNCOMMITTED: {
                    this.askForCommit();
                }
            }
            for (GitRevisionInfo commit : result.getCherryPickedCommits()) {
                GitUtils.printInfo(sb, commit);
            }
            if (sb.length() > 0) {
                this.logger.outputLine(sb.toString());
            }
        }

        public GitClient.CherryPickOperation getNextAction() {
            return this.nextAction;
        }

        private GitClient.CherryPickOperation resolveCherryPickConflicts(Collection<VCSFileProxy> conflicts) {
            GitClient.CherryPickOperation action = null;
            JButton abort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)abort, (String)Bundle.LBL_CherryPickResultProcessor_abortButton_text());
            abort.setToolTipText(Bundle.LBL_CherryPickResultProcessor_abortButton_TTtext());
            JButton resolve = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)resolve, (String)Bundle.LBL_CherryPickResultProcessor_resolveButton_text());
            resolve.setToolTipText(Bundle.LBL_CherryPickResultProcessor_resolveButton_TTtext());
            JButton review = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)review, (String)Bundle.LBL_CherryPickResultProcessor_reviewButton_text());
            review.setToolTipText(Bundle.LBL_CherryPickResultProcessor_reviewButton_TTtext());
            Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_CherryPickResultProcessor_resolveConflicts(), Bundle.LBL_CherryPickResultProcessor_resolveConflicts(), 2, 3, new Object[]{resolve, review, abort, NotifyDescriptor.CANCEL_OPTION}, (Object)resolve));
            if (o == review) {
                this.openInVersioningView(conflicts);
            } else if (o == resolve) {
                ResolveConflictsExecutor executor = new ResolveConflictsExecutor(conflicts.toArray(new VCSFileProxy[conflicts.size()]));
                executor.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, Bundle.MSG_CherryPick_resolving());
            } else if (o == abort) {
                action = GitClient.CherryPickOperation.ABORT;
            }
            return action;
        }

        private void askForCommit() {
            JButton commit = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)commit, (String)Bundle.LBL_CherryPickResultProcessor_commit_commitButton_text());
            commit.setToolTipText(Bundle.LBL_CherryPickResultProcessor_commit_commitButton_TTtext());
            JButton review = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)review, (String)Bundle.LBL_CherryPickResultProcessor_commit_reviewButton_text());
            review.setToolTipText(Bundle.LBL_CherryPickResultProcessor_commit_reviewButton_TTtext());
            Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_CherryPickResultProcessor_commit(), Bundle.LBL_CherryPickResultProcessor_commit(), 2, 3, new Object[]{commit, review, NotifyDescriptor.CANCEL_OPTION}, (Object)commit));
            final VCSContext context = GitUtils.getContextForFile(this.repository);
            if (o == commit) {
                ((CommitAction)SystemAction.get(CommitAction.class)).performAction(context);
            } else if (o == review) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        ((StatusAction)SystemAction.get(StatusAction.class)).performContextAction(context);
                    }
                });
            }
        }
    }
}

