/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.hibernate.editor.DocumentContext;
import org.netbeans.modules.hibernate.editor.EditorContextFactory;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CompletionContext {
    private ArrayList<String> existingAttributes;
    private static final Logger LOGGER = Logger.getLogger(CompletionContext.class.getName());
    private CompletionType completionType = CompletionType.NONE;
    private Document doc;
    private int caretOffset;
    private DocumentContext documentContext;
    private String typedChars = "";
    private char lastTypedChar;
    private XMLSyntaxSupport support;

    public CompletionContext(Document doc, int caretOffset) {
        this.doc = doc;
        this.caretOffset = caretOffset;
        try {
            this.support = (XMLSyntaxSupport)((BaseDocument)doc).getSyntaxSupport();
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.FINE, cce.getMessage());
            this.support = new XMLSyntaxSupport((BaseDocument)doc);
        }
        this.documentContext = EditorContextFactory.getDocumentContext(doc, caretOffset);
        this.lastTypedChar = this.support.lastTypedChar();
        this.initContext();
    }

    private void initContext() {
        TokenItem token = this.documentContext.getCurrentToken();
        if (token == null) {
            return;
        }
        boolean tokenBoundary = token.getOffset() == this.caretOffset || token.getOffset() + token.getImage().length() == this.caretOffset;
        int id = token.getTokenID().getNumericID();
        SyntaxElement element = this.documentContext.getCurrentElement();
        switch (id) {
            case 1: {
                String chars = token.getImage().trim();
                if (chars != null && chars.equals("") && token.getPrevious().getImage().trim().equals("/>")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.equals("") && token.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (chars != null && !chars.startsWith("<") && token.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    this.typedChars = "";
                    break;
                }
                if (chars != null && !chars.equals("<") && token.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.startsWith("<")) {
                    this.typedChars = chars.substring(1);
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 4: {
                if (element instanceof EndTag) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (element instanceof EmptyTag) {
                    if (token != null && token.getImage().trim().equals("/>")) {
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    EmptyTag tag = (EmptyTag)element;
                    if (element.getElementOffset() + 1 == this.caretOffset) {
                        this.completionType = CompletionType.TAG;
                        break;
                    }
                    if (this.caretOffset > element.getElementOffset() + 1 && this.caretOffset <= element.getElementOffset() + 1 + tag.getTagName().length()) {
                        this.completionType = CompletionType.TAG;
                        this.typedChars = tag.getTagName();
                        break;
                    }
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (element instanceof StartTag) {
                    if (token != null && token.getImage().trim().equals(">")) {
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (token != null && token.getImage().trim().startsWith("</")) {
                        this.typedChars = "";
                        this.completionType = CompletionType.VALUE;
                        break;
                    }
                    if (element.getElementOffset() + 1 != this.caretOffset) {
                        StartTag tag = (StartTag)element;
                        this.typedChars = tag.getTagName();
                    }
                }
                if (element instanceof Text && token != null && token.getImage().trim().startsWith("</")) {
                    this.typedChars = token.getPrevious().getImage().trim();
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (this.lastTypedChar == '>') {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 5: {
                this.completionType = CompletionType.ATTRIBUTE;
                this.typedChars = token.getImage().substring(0, this.caretOffset - token.getOffset());
                break;
            }
            case 6: 
            case 11: {
                this.completionType = CompletionType.NONE;
                break;
            }
            case 7: {
                if (!tokenBoundary) {
                    this.completionType = CompletionType.ATTRIBUTE_VALUE;
                    this.typedChars = token.getImage().substring(1, this.caretOffset - token.getOffset());
                    break;
                }
                this.completionType = CompletionType.NONE;
                break;
            }
            case 2: {
                TokenItem prev;
                this.completionType = CompletionType.NONE;
                for (prev = token.getPrevious(); prev != null && prev.getTokenID().getNumericID() == 2; prev = prev.getPrevious()) {
                }
                if (prev.getTokenID().getNumericID() == 5) {
                    this.typedChars = prev.getImage();
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (prev.getTokenID().getNumericID() != 7 && prev.getTokenID().getNumericID() != 4) break;
                this.completionType = CompletionType.ATTRIBUTE;
                break;
            }
            default: {
                this.completionType = CompletionType.NONE;
            }
        }
    }

    public CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getTypedPrefix() {
        return this.typedChars;
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public Node getTag() {
        SyntaxElement element = this.documentContext.getCurrentElement();
        return element instanceof Tag ? (Node)element : null;
    }

    public TokenItem getCurrentToken() {
        return this.documentContext.getCurrentToken();
    }

    public List<String> getExistingAttributes() {
        if (this.existingAttributes != null) {
            return this.existingAttributes;
        }
        this.existingAttributes = new ArrayList();
        for (TokenItem item = this.documentContext.getCurrentToken().getPrevious(); item != null && item.getTokenID().getNumericID() != 4; item = item.getPrevious()) {
            if (item.getTokenID().getNumericID() != 5) continue;
            this.existingAttributes.add(item.getImage());
        }
        return this.existingAttributes;
    }

    public static enum CompletionType {
        TAG,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        NONE;

    }
}

