/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.hibernate.completion.CompletionContext;
import org.netbeans.modules.hibernate.completion.HibernateCompletionItem;
import org.netbeans.modules.hibernate.completion.HibernateMappingCompletionManager;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;

public class HibernateMappingCompletionQuery
extends AsyncCompletionQuery {
    private int queryType;
    private int caretOffset;
    private JTextComponent component;

    public HibernateMappingCompletionQuery(int queryType, int caretOffset) {
        this.queryType = queryType;
        this.caretOffset = caretOffset;
    }

    protected void preQueryUpdate(JTextComponent component) {
        this.component = component;
    }

    protected void prepareQuery(JTextComponent component) {
        this.component = component;
    }

    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
        ArrayList<HibernateCompletionItem> completionItems = new ArrayList<HibernateCompletionItem>();
        int anchorOffset = this.getCompletionItems(doc, caretOffset, completionItems);
        resultSet.addAllItems(completionItems);
        if (anchorOffset != -1) {
            resultSet.setAnchorOffset(anchorOffset);
        }
        resultSet.finish();
    }

    int getCompletionItems(Document doc, int caretOffset, List<HibernateCompletionItem> completionItems) {
        int anchorOffset = -1;
        CompletionContext context = new CompletionContext(doc, caretOffset);
        if (context.getCompletionType() == CompletionContext.CompletionType.NONE) {
            return anchorOffset;
        }
        switch (context.getCompletionType()) {
            case ATTRIBUTE_VALUE: {
                anchorOffset = HibernateMappingCompletionManager.getDefault().completeAttributeValues(context, completionItems);
                break;
            }
            case ATTRIBUTE: {
                anchorOffset = HibernateMappingCompletionManager.getDefault().completeAttributes(context, completionItems);
                break;
            }
            case TAG: {
                anchorOffset = HibernateMappingCompletionManager.getDefault().completeElements(context, completionItems);
            }
        }
        return anchorOffset;
    }
}

