/**
 * When associating an object to a key on a node using Node.setUserData() the application can provide a handler that gets called when the node the object is associated to is being cloned, imported, or renamed. This can be used by the application to implement various behaviors regarding the data it associates to the DOM nodes. This interface defines that handler.
 */
var UserDataHandler = {
}
/**
 * This method is called whenever the node for which this handler is registered is imported or cloned. DOM applications must not raise exceptions in a UserDataHandler. The effect of throwing exceptions from the handler is DOM implementation dependent.
 * @syntax userDataHandler.handle(operation, key, data, src, dst)
 * @param {Number} operation Specifies the type of operation that is being performed on the node.
 * @param {String} key Specifies the key for which this handler is being called.
 * @param {DOMUserData} data Specifies the data for which this handler is being called.
 * @param {Node} src Specifies the node being cloned, adopted, imported, or renamed. This is null when the node is being deleted.
 * @param {Node} dst Specifies the node newly created if any, or null.
 * @returns {undefined} 
 */
UserDataHandler.prototype.handle = function(operation,  key,  data,  src,  dst) {};

/**
 * The node is imported, using Document.importNode().
 * @syntax UserDataHandler.NODE_IMPORTED
 * @returns {Number} 
 * @static
 */
UserDataHandler.NODE_IMPORTED = new Number();

/**
 * The node is adopted, using Document.adoptNode().
 * @syntax UserDataHandler.NODE_ADOPTED
 * @returns {Number} 
 * @static
 */
UserDataHandler.NODE_ADOPTED = new Number();

/**
 * The node is renamed, using Document.renameNode().
 * @syntax UserDataHandler.NODE_RENAMED
 * @returns {Number} 
 * @static
 */
UserDataHandler.NODE_RENAMED = new Number();

/**
 * The node is deleted. Note: This may not be supported or may not be reliable in certain environments, such as Java, where the implementation has no real control over when objects are actually deleted.
 * @syntax UserDataHandler.NODE_DELETED
 * @returns {Number} 
 * @static
 */
UserDataHandler.NODE_DELETED = new Number();

/**
 * The node is cloned, using Node.cloneNode().
 * @syntax UserDataHandler.NODE_CLONED
 * @returns {Number} 
 * @static
 */
UserDataHandler.NODE_CLONED = new Number();

/**
 * Represents the UserDataHandler prototype object.
 * @syntax UserDataHandler.prototype
 * @static
 */
UserDataHandler.prototype;

