/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * smoothstep(-1.9lf, -0.6333333333333333lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(0.0lf, 0.9979588861350052lf, 1.0lf)
 * smoothstep(-1.9lf, -0.6333333333333333lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.0lf, 0.0lf, 0.9979588861350052lf)
 * smoothstep(-1.9lf, 0.6333333333333333lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(0.0lf, 0.4802677139524711lf, 1.0lf)
 * smoothstep(-1.9lf, 0.6333333333333333lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.0lf, 0.0lf, 0.4802677139524711lf)
 * smoothstep(-1.9lf, 1.9lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(0.0lf, 0.2476416495223901lf, 0.7523583504776098lf)
 * smoothstep(-1.9lf, 1.9lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.0lf, 0.0lf, 0.2476416495223901lf)
 * smoothstep(-0.6333333333333333lf, 0.6333333333333333lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(0.0lf, 0.0lf, 1.0lf)
 * smoothstep(-0.6333333333333333lf, 0.6333333333333333lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.0lf, 0.0lf, 0.0lf)
 * smoothstep(-0.6333333333333333lf, 1.9lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(0.0lf, 0.0lf, 0.5197322860475286lf)
 * smoothstep(-0.6333333333333333lf, 1.9lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.0lf, 0.0lf, 0.0lf)
 * smoothstep(0.6333333333333333lf, 1.9lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)) => dvec3(0.0lf, 0.0lf, 0.0020411138649948832lf)
 * smoothstep(0.6333333333333333lf, 1.9lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)) => dvec3(1.0lf, 0.0lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(smoothstep(-1.9lf, -0.6333333333333333lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(0.0lf, 0.9979588861350052lf, 1.0lf)) <= 1.4127710141476646e-05lf ? 1 : -1] array0;
  double[distance(smoothstep(-1.9lf, -0.6333333333333333lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.0lf, 0.0lf, 0.9979588861350052lf)) <= 1.4127710141476646e-05lf ? 1 : -1] array1;
  double[distance(smoothstep(-1.9lf, 0.6333333333333333lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(0.0lf, 0.4802677139524711lf, 1.0lf)) <= 1.1093498443075262e-05lf ? 1 : -1] array2;
  double[distance(smoothstep(-1.9lf, 0.6333333333333333lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.0lf, 0.0lf, 0.4802677139524711lf)) <= 1.1093498443075262e-05lf ? 1 : -1] array3;
  double[distance(smoothstep(-1.9lf, 1.9lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(0.0lf, 0.2476416495223901lf, 0.7523583504776098lf)) <= 7.920665843927267e-06lf ? 1 : -1] array4;
  double[distance(smoothstep(-1.9lf, 1.9lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.0lf, 0.0lf, 0.2476416495223901lf)) <= 1.0302069629827643e-05lf ? 1 : -1] array5;
  double[distance(smoothstep(-0.6333333333333333lf, 0.6333333333333333lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(0.0lf, 0.0lf, 1.0lf)) <= 1e-05lf ? 1 : -1] array6;
  double[distance(smoothstep(-0.6333333333333333lf, 0.6333333333333333lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.0lf, 0.0lf, 0.0lf)) <= 1e-05lf ? 1 : -1] array7;
  double[distance(smoothstep(-0.6333333333333333lf, 1.9lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(0.0lf, 0.0lf, 0.5197322860475286lf)) <= 5.197322860475287e-06lf ? 1 : -1] array8;
  double[distance(smoothstep(-0.6333333333333333lf, 1.9lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.0lf, 0.0lf, 0.0lf)) <= 1e-05lf ? 1 : -1] array9;
  double[distance(smoothstep(0.6333333333333333lf, 1.9lf, dvec3(-2.0lf, -0.6666666666666667lf, 0.6666666666666665lf)), dvec3(0.0lf, 0.0lf, 0.0020411138649948832lf)) <= 2.0411138649948833e-08lf ? 1 : -1] array10;
  double[distance(smoothstep(0.6333333333333333lf, 1.9lf, dvec3(2.0lf, -2.0lf, -0.6666666666666667lf)), dvec3(1.0lf, 0.0lf, 0.0lf)) <= 1e-05lf ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
