/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mod(vec3(-1.9, -1.9, -1.9), vec3(-2.0, -0.6666667, 0.6666667)) => vec3(-1.9, -0.5666666, 0.10000008)
 * mod(vec3(-1.9, -0.6333333, -0.6333333), vec3(2.0, -2.0, -0.6666667)) => vec3(0.100000024, -0.6333333, -0.6333333)
 * mod(vec3(-0.6333333, -0.6333333, 0.6333333), vec3(0.6666667, 2.0, -2.0)) => vec3(0.03333336, 1.3666667, -1.3666667)
 * mod(vec3(0.6333333, 0.6333333, 0.6333333), vec3(-0.6666667, 0.6666667, 2.0)) => vec3(-0.03333336, 0.6333333, 0.6333333)
 * mod(vec3(1.9, 1.9, 1.9), vec3(-2.0, -0.6666667, 0.6666667)) => vec3(-0.100000024, -0.10000008, 0.5666666)
 * mod(vec3(1.9, -1.9, -1.9), vec3(2.0, -2.0, -0.6666667)) => vec3(1.9, -1.9, -0.5666666)
 */
#version 120

void main()
{
  float[distance(mod(vec3(-1.9, -1.9, -1.9), vec3(-2.0, -0.6666667, 0.6666667)), vec3(-1.9, -0.5666666, 0.10000008)) <= 1.985223e-05 ? 1 : -1] array0;
  float[distance(mod(vec3(-1.9, -0.6333333, -0.6333333), vec3(2.0, -2.0, -0.6666667)), vec3(0.100000024, -0.6333333, -0.6333333)) <= 9.012337e-06 ? 1 : -1] array1;
  float[distance(mod(vec3(-0.6333333, -0.6333333, 0.6333333), vec3(0.6666667, 2.0, -2.0)), vec3(0.03333336, 1.3666667, -1.3666667)) <= 1.9330459e-05 ? 1 : -1] array2;
  float[distance(mod(vec3(0.6333333, 0.6333333, 0.6333333), vec3(-0.6666667, 0.6666667, 2.0)), vec3(-0.03333336, 0.6333333, 0.6333333)) <= 8.962887e-06 ? 1 : -1] array3;
  float[distance(mod(vec3(1.9, 1.9, 1.9), vec3(-2.0, -0.6666667, 0.6666667)), vec3(-0.100000024, -0.10000008, 0.5666666)) <= 5.840471e-06 ? 1 : -1] array4;
  float[distance(mod(vec3(1.9, -1.9, -1.9), vec3(2.0, -2.0, -0.6666667)), vec3(1.9, -1.9, -0.5666666)) <= 2.7461083e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
