/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jna;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.Native;

public class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(Logger logger) {
        if (ourJnaLoaded == null) {
            ourJnaLoaded = Boolean.FALSE;
            try {
                long t = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t = System.currentTimeMillis() - t;
                logger.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t) {
                logger.error("Unable to load JNA library (OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ")", t);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }
}

