/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;

public class ConcurrentInstanceMap {
    public static <T> Map<Class<? extends T>, T> create() {
        return ConcurrentFactoryMap.createMap(new Function<Class<? extends T>, T>(){

            @Override
            public T fun(Class<? extends T> key) {
                return ConcurrentInstanceMap.calculate(key);
            }
        });
    }

    public static <T> T calculate(Class<? extends T> key) {
        try {
            return key.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + key, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't instantiate " + key, e);
        }
    }
}

